/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrainChunkLoader
implements ChunkLoader {
    private final Train train;
    public final List<CarriageChunkLoader> carriageLoaders = new LinkedList<CarriageChunkLoader>();
    private final Map<ResourceKey<Level>, Set<ChunkLoadManager.LoadedChunkPos>> reclaimedChunks = new HashMap<ResourceKey<Level>, Set<ChunkLoadManager.LoadedChunkPos>>();
    private boolean registered = false;

    public TrainChunkLoader(Train train) {
        this.train = train;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        HashSet<ChunkLoadManager.LoadedChunkPos> allForced = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            allForced.addAll(loader.getForcedChunks());
        }
        return allForced;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.TRAIN;
    }

    @Override
    public LoaderType getLoaderType() {
        for (CarriageChunkLoader carriageLoader : this.carriageLoaders) {
            if (carriageLoader.getLoaderType() != LoaderType.BRASS) continue;
            return LoaderType.BRASS;
        }
        return LoaderType.ANDESITE;
    }

    @Override
    public Pair<ResourceLocation, BlockPos> getLocation() {
        if (this.train.graph == null) {
            return null;
        }
        return this.train.carriages.stream().findFirst().map(carriage -> Pair.of((Object)carriage.leadingBogey().trailing().node1.getLocation().getDimension().location(), (Object)BlockPos.containing((Position)carriage.leadingBogey().trailing().getPosition(this.train.graph)))).orElse(null);
    }

    @Override
    public void addToManager() {
        if (!this.registered) {
            ChunkLoader.super.addToManager();
            this.registered = true;
        }
    }

    public void tick(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.addToManager();
        if (this.carriageLoaders.size() != this.train.carriages.size()) {
            LinkedList<CarriageChunkLoader> newLoaders = new LinkedList<CarriageChunkLoader>();
            for (Carriage carriage : this.train.carriages) {
                CarriageChunkLoader loader = this.carriageLoaders.stream().filter(x -> x.carriage == carriage).findFirst().orElseGet(() -> new CarriageChunkLoader(carriage, false, false, false));
                newLoaders.add(loader);
            }
            this.carriageLoaders.clear();
            this.carriageLoaders.addAll(newLoaders);
        }
        ChunkLoadManager.reclaimChunks(level, this.train.id, this.reclaimedChunks);
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            loader.tick(level);
        }
    }

    public void onRemove() {
        for (CarriageChunkLoader loader : this.carriageLoaders) {
            loader.onRemove();
        }
        this.removeFromManager();
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("CarriageLoaders", (Tag)NBTHelper.writeCompoundList(this.carriageLoaders, CarriageChunkLoader::write));
        return nbt;
    }

    public static TrainChunkLoader read(Train train, CompoundTag nbt) {
        TrainChunkLoader loader = new TrainChunkLoader(train);
        ListTag list = nbt.getList("CarriageLoaders", 10);
        if (list.size() == train.carriages.size()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = (CompoundTag)list.get(i);
                loader.carriageLoaders.add(CarriageChunkLoader.read((Carriage)train.carriages.get(i), tag));
            }
        }
        return loader;
    }
}

