/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public enum ConnectorMode implements StringRepresentable
{
    Push("push"),
    Pull("pull"),
    None("none"),
    Passive("passive");

    private String name;

    private ConnectorMode(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public ConnectorMode getNext() {
        return switch (this.ordinal()) {
            case 2 -> Pull;
            case 1 -> Push;
            case 0 -> None;
            default -> None;
        };
    }

    public MutableComponent getTooltip() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Component.translatable((String)"createaddition.tooltip.energy.passive");
            case 2 -> Component.translatable((String)"createaddition.tooltip.energy.none");
            case 1 -> Component.translatable((String)"createaddition.tooltip.energy.pull");
            case 0 -> Component.translatable((String)"createaddition.tooltip.energy.push");
        };
    }

    public boolean isActive() {
        return this == Push || this == Pull;
    }

    public static ConnectorMode test(Level level, BlockPos pos, Direction face) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null) {
            return None;
        }
        IEnergyStorage energy = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)face);
        if (energy == null) {
            energy = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null);
        }
        if (energy == null) {
            return None;
        }
        if (energy.canExtract()) {
            return Pull;
        }
        if (energy.canReceive()) {
            return Push;
        }
        return None;
    }
}

