/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class AbstractElectricBlockEntity
extends SmartBlockEntity {
    protected final InternalEnergyStorage localEnergy;
    private final EnumSet<Direction> invalidSides = EnumSet.allOf(Direction.class);
    private final EnumMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> escacheMap = new EnumMap(Direction.class);

    public AbstractElectricBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.localEnergy = new InternalEnergyStorage(this.getCapacity(), this.getMaxIn(), this.getMaxOut());
        this.setLazyTickRate(20);
    }

    public abstract int getCapacity();

    public abstract int getMaxIn();

    public abstract int getMaxOut();

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public abstract boolean isEnergyInput(Direction var1);

    public abstract boolean isEnergyOutput(Direction var1);

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.localEnergy.read(tag);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.localEnergy.write(tag);
    }

    @Deprecated
    public void outputTick(int max) {
        for (Direction side : Direction.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.localEnergy.outputToSide(this.level, this.worldPosition, side, max);
        }
    }

    public void tick() {
        super.tick();
        if (!this.invalidSides.isEmpty()) {
            this.invalidSides.forEach(this::updateCache);
            this.invalidSides.clear();
        }
    }

    public void updateCache(Direction side) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.level.isLoaded(this.worldPosition.relative(side))) {
            this.escacheMap.put(side, null);
            return;
        }
        BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.invalidSides.add(side));
        this.escacheMap.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)cache);
    }
}

