/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge.mixins.client;

import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.installer.GitlabGetter;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.updater.UpdateModScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Unique
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    @Unique
    private static final boolean DEBUG_ALWAYS_SHOW_UPDATER = false;

    @Redirect(method={"Lnet/minecraft/client/Minecraft;onGameLoadFinished(Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at=@At(value="INVOKE", target="Ljava/lang/Runnable;run()V"))
    private void buildInitialScreens(Runnable runnable) {
        boolean showUpdater = SelfUpdater.onStart();
        if (showUpdater && Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue()) {
            runnable = () -> {
                EDhApiUpdateBranch updateBranch = EDhApiUpdateBranch.convertAutoToStableOrNightly(Config.Client.Advanced.AutoUpdater.updateBranch.get());
                String versionId = updateBranch == EDhApiUpdateBranch.STABLE ? ModrinthGetter.getLatestIDForVersion(SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion()) : (String)GitlabGetter.INSTANCE.projectPipelines.get(0).get("sha");
                if (versionId != null) {
                    try {
                        Minecraft.getInstance().setScreen((Screen)new UpdateModScreen((Screen)new TitleScreen(false), versionId));
                    }
                    catch (Exception e) {
                        LOGGER.info("Unable to show DH update screen, reason: [" + e.getMessage() + "].", new Object[0]);
                    }
                } else {
                    LOGGER.info("Unable to find new DH update for the [" + String.valueOf((Object)updateBranch) + "] branch. Assuming DH is up to date...", new Object[0]);
                }
            };
        }
        runnable.run();
    }

    @Inject(at={@At(value="HEAD")}, method={"close()V"}, remap=false)
    public void close(CallbackInfo ci) {
        SelfUpdater.onClose();
    }
}

