/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.google.common.collect.ImmutableMap;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.IBatchGeneratorEnvironmentWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.ChunkPosGenStream;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.InternalServerGenerator;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.ChunkFileReader;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.GlobalWorldGenParams;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepBiomes;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepFeatures;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepNoise;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureReference;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureStart;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepSurface;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2891;
import net.minecraft.class_2897;
import net.minecraft.class_3754;
import net.minecraft.class_5281;
import org.jetbrains.annotations.NotNull;

public final class BatchGenerationEnvironment
implements IBatchGeneratorEnvironmentWrapper {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD World Gen").fileLevelConfig(Config.Common.Logging.logWorldGenEventToFile).build();
    public static final DhLogger RATE_LIMITED_LOGGER = new DhLoggerBuilder().name("LOD World Gen").maxCountPerSecond(1).build();
    @NotNull
    public static final ImmutableMap<EDhApiWorldGenerationStep, Integer> WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP;
    public static final int MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;
    public static final long EXCEPTION_TIMER_RESET_TIME;
    public static final int EXCEPTION_COUNTER_TRIGGER = 20;
    private static final int MS_TO_IGNORE_CHUNK_AFTER_COMPLETION = 5000;
    private final IDhServerLevel dhServerLevel;
    public final InternalServerGenerator internalServerGenerator;
    public final ChunkFileReader chunkFileReader;
    private final Timer chunkSaveIgnoreTimer = TimerUtil.CreateTimer("ChunkSaveIgnoreTimer");
    public final LinkedBlockingQueue<GenerationEvent> generationEventQueue = new LinkedBlockingQueue();
    public final GlobalWorldGenParams globalParams;
    public final StepStructureStart stepStructureStart = new StepStructureStart(this);
    public final StepStructureReference stepStructureReference = new StepStructureReference(this);
    public final StepBiomes stepBiomes = new StepBiomes(this);
    public final StepNoise stepNoise = new StepNoise(this);
    public final StepSurface stepSurface = new StepSurface(this);
    public final StepFeatures stepFeatures = new StepFeatures(this);
    public boolean unsafeThreadingRecorded = false;
    public boolean generatedChunkWithoutBiomeWarningLogged = false;
    public int unknownExceptionCount = 0;
    public long lastExceptionTriggerTime = 0L;
    public static ThreadLocal<Boolean> isDhWorldGenThreadRef;

    public static boolean isThisDhWorldGenThread() {
        return isDhWorldGenThreadRef.get() != null;
    }

    public BatchGenerationEnvironment(IDhServerLevel dhServerLevel) {
        boolean isMcGenerator;
        this.dhServerLevel = dhServerLevel;
        this.globalParams = new GlobalWorldGenParams(dhServerLevel);
        this.internalServerGenerator = new InternalServerGenerator(this.globalParams, this.dhServerLevel);
        this.chunkFileReader = new ChunkFileReader(this.globalParams);
        class_2794 generator = ((ServerLevelWrapper)dhServerLevel.getServerLevelWrapper()).getLevel().method_14178().method_12129();
        boolean bl = isMcGenerator = generator instanceof class_3754 || generator instanceof class_2891 || generator instanceof class_2897;
        if (!isMcGenerator) {
            if (generator.getClass().toString().equals("class com.terraforged.mod.chunk.TFChunkGenerator")) {
                LOGGER.info("TerraForge Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else if (generator.getClass().toString().equals("class net.dries007.tfc.world.TFCChunkGenerator")) {
                LOGGER.info("TerraFirmaCraft Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else {
                LOGGER.warn("Unknown Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation May Fail!", new Object[0]);
                LOGGER.warn("If it does crash, disable Distant Generation or set the Generation Mode to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            }
        }
    }

    public <T> T confirmFutureWasRunSynchronously(CompletableFuture<T> future) {
        if (!this.unsafeThreadingRecorded && !future.isDone()) {
            LOGGER.warn("Unsafe MultiThreading in Distant Horizons Chunk Generator. \nThis can happen if world generation is run on one of Minecraft's thread pools instead of the thread DH provided. \nThis can likely be ignored, however if world generator crashes occur setting DH's world generation thread count to 1 may improve stability. ", new RuntimeException("Incorrect thread pool use"));
            this.unsafeThreadingRecorded = true;
        }
        return future.join();
    }

    @Override
    public void updateAllFutures() {
        if (this.unknownExceptionCount > 0 && System.nanoTime() - this.lastExceptionTriggerTime >= EXCEPTION_TIMER_RESET_TIME) {
            this.unknownExceptionCount = 0;
        }
        Iterator<GenerationEvent> iter = this.generationEventQueue.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            if (!event.future.isDone()) continue;
            if (event.future.isCompletedExceptionally() && !event.future.isCancelled()) {
                try {
                    event.future.get();
                    LodUtil.assertNotReach("Exceptionally completed world gen Future should have thrown an exception.");
                }
                catch (Exception e) {
                    ++this.unknownExceptionCount;
                    this.lastExceptionTriggerTime = System.nanoTime();
                    LOGGER.error("Batching World Generator event [" + String.valueOf(event) + "] threw an exception: " + e.getMessage(), e);
                }
            }
            iter.remove();
        }
        if (this.unknownExceptionCount > 20) {
            LOGGER.error("Too many exceptions in Batching World Generator! Disabling the generator.", new Object[0]);
            this.unknownExceptionCount = 0;
            Config.Common.WorldGenerator.enableDistantGeneration.set(false);
        }
    }

    public void generateEvent(GenerationEvent genEvent) throws RejectedExecutionException {
        LodUtil.assertTrue(genEvent.widthInChunks % 2 == 0, "Generation events are expected to be an evan number of chunks wide.");
        if (!DhApi.isDhThread() && ModInfo.IS_DEV_BUILD) {
            throw new IllegalStateException("Batch world generation should be called from one of DH's world gen thread. Current thread: [" + Thread.currentThread().getName() + "]");
        }
        int borderSize = MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;
        int refSize = genEvent.widthInChunks - 1 + borderSize * 2;
        int refPosX = genEvent.minPos.getX() - borderSize;
        int refPosZ = genEvent.minPos.getZ() - borderSize;
        LightGetterAdaptor lightGetterAdaptor = new LightGetterAdaptor((class_1922)this.globalParams.mcServerLevel);
        DummyLightEngine dummyLightEngine = new DummyLightEngine(lightGetterAdaptor);
        Map<DhChunkPos, ChunkLightStorage> chunkSkyLightingByDhPos = Collections.synchronizedMap(new HashMap());
        Map<DhChunkPos, ChunkLightStorage> chunkBlockLightingByDhPos = Collections.synchronizedMap(new HashMap());
        Map<DhChunkPos, ChunkWrapper> chunkWrappersByDhPos = Collections.synchronizedMap(new HashMap());
        HashMap<DhChunkPos, CompletableFuture<ChunkWrapper>> readFutureByDhChunkPos = new HashMap<DhChunkPos, CompletableFuture<ChunkWrapper>>();
        Iterator<class_1923> existingChunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
        while (existingChunkPosIterator.hasNext()) {
            class_1923 chunkPos = existingChunkPosIterator.next();
            DhChunkPos dhChunkPos = new DhChunkPos(chunkPos.field_9181, chunkPos.field_9180);
            CompletableFuture<ChunkWrapper> getExistingChunkFuture = this.chunkFileReader.createEmptyOrPreExistingChunkWrapperAsync(chunkPos.field_9181, chunkPos.field_9180, chunkSkyLightingByDhPos, chunkBlockLightingByDhPos, chunkWrappersByDhPos);
            readFutureByDhChunkPos.put(dhChunkPos, getExistingChunkFuture);
        }
        for (CompletableFuture readChunkFuture : readFutureByDhChunkPos.values()) {
            readChunkFuture.join();
        }
        Iterator<class_1923> emptyChunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 8);
        while (emptyChunkPosIterator.hasNext()) {
            class_1923 chunkPos = emptyChunkPosIterator.next();
            DhChunkPos dhChunkPos = new DhChunkPos(chunkPos.field_9181, chunkPos.field_9180);
            if (readFutureByDhChunkPos.containsKey(dhChunkPos)) continue;
            ChunkWrapper chunkWrapper = this.chunkFileReader.CreateProtoChunkWrapper(this.globalParams.mcServerLevel, chunkPos);
            chunkWrappersByDhPos.put(dhChunkPos, chunkWrapper);
        }
        try {
            for (int xOffset = 0; xOffset < 2; ++xOffset) {
                int xOffsetFinal = xOffset;
                for (int zOffset = 0; zOffset < 2; ++zOffset) {
                    int zOffsetFinal = zOffset;
                    int radius = refSize / 2;
                    int centerX = refPosX + radius + xOffset;
                    int centerZ = refPosZ + radius + zOffset;
                    IEmptyChunkRetrievalFunc fallbackChunkGetterFunc = (chunkPosX, chunkPosZ) -> Objects.requireNonNull(((ChunkWrapper)chunkWrappersByDhPos.get(new DhChunkPos(chunkPosX, chunkPosZ))).getChunk(), () -> String.format("Requested chunk [%d, %d] unavailable during world generation", chunkPosX, chunkPosZ));
                    ArrayGridList<class_2791> regionChunks = new ArrayGridList<class_2791>(refSize, (relX, relZ) -> fallbackChunkGetterFunc.getChunk(relX + refPosX + xOffsetFinal, relZ + refPosZ + zOffsetFinal));
                    class_2791 centerChunk = regionChunks.stream().filter(chunk -> chunk.method_12004().field_9181 == centerX && chunk.method_12004().field_9180 == centerZ).findFirst().orElseGet(() -> (class_2791)regionChunks.getFirst());
                    DhLitWorldGenRegion region = new DhLitWorldGenRegion(centerX, centerZ, centerChunk, this.globalParams.mcServerLevel, dummyLightEngine, regionChunks, class_2806.field_16423, radius, fallbackChunkGetterFunc);
                    lightGetterAdaptor.setRegion(region);
                    genEvent.threadedParam.makeStructFeatManager((class_5281)region, this.globalParams);
                    ArrayGridList<ChunkWrapper> chunkWrapperList = new ArrayGridList<ChunkWrapper>(regionChunks.gridSize);
                    regionChunks.forEachPos((relX, relZ) -> {
                        DhChunkPos chunkPos = new DhChunkPos(relX + refPosX + xOffsetFinal, relZ + refPosZ + zOffsetFinal);
                        class_2791 chunk = (class_2791)regionChunks.get((int)relX, (int)relZ);
                        if (chunkWrappersByDhPos.containsKey(chunkPos)) {
                            chunkWrapperList.set((int)relX, (int)relZ, (ChunkWrapper)chunkWrappersByDhPos.get(chunkPos));
                        } else if (chunk != null) {
                            ChunkWrapper chunkWrapper = new ChunkWrapper(chunk, this.dhServerLevel.getLevelWrapper());
                            chunkWrapper.createDhHeightMaps();
                            chunkWrapperList.set((int)relX, (int)relZ, chunkWrapper);
                            if (chunkBlockLightingByDhPos.containsKey(chunkWrapper.getChunkPos())) {
                                ChunkLightStorage skyLightStorage;
                                ChunkLightStorage blockLightStorage = (ChunkLightStorage)chunkBlockLightingByDhPos.get(chunkWrapper.getChunkPos());
                                if (blockLightStorage != null && !blockLightStorage.isEmpty()) {
                                    chunkWrapper.setBlockLightStorage(blockLightStorage);
                                    chunkWrapper.setIsDhBlockLightCorrect(true);
                                }
                                if ((skyLightStorage = (ChunkLightStorage)chunkSkyLightingByDhPos.get(chunkWrapper.getChunkPos())) != null && !skyLightStorage.isEmpty()) {
                                    chunkWrapper.setSkyLightStorage(skyLightStorage);
                                    chunkWrapper.setIsDhSkyLightCorrect(true);
                                }
                            }
                            chunkWrappersByDhPos.put(chunkPos, chunkWrapper);
                        } else {
                            LodUtil.assertNotReach("Programmer Error: No chunk found in grid list, position offset is likely wrong.");
                        }
                    });
                    try {
                        this.generateDirect(genEvent, chunkWrapperList, region);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                }
            }
            Iterator<class_1923> iterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
            while (iterator.hasNext()) {
                class_1923 pos = iterator.next();
                DhChunkPos dhPos = new DhChunkPos(pos.field_9181, pos.field_9180);
                ChunkWrapper wrappedChunk = chunkWrappersByDhPos.get(dhPos);
                if (wrappedChunk.getStatus().method_12165(class_2806.field_12794)) {
                    genEvent.resultConsumer.accept(wrappedChunk);
                    continue;
                }
                if (this.generatedChunkWithoutBiomeWarningLogged) continue;
                this.generatedChunkWithoutBiomeWarningLogged = true;
                LOGGER.warn("Chunk [" + String.valueOf(dhPos) + "] wasn't generated up to BIOMES, world gen may appear empty.", new Object[0]);
            }
        }
        catch (UncheckedInterruptedException | CompletionException e) {
            boolean isShutdownException = ExceptionUtil.isShutdownException(e);
            if (!isShutdownException) {
                LOGGER.error("Completion error during world gen for min chunk pos [" + String.valueOf(genEvent.minPos) + "], error: [" + e.getMessage() + "].", e);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error during world gen for min chunk pos [" + String.valueOf(genEvent.minPos) + "], error: [" + e.getMessage() + "].", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDirect(GenerationEvent genEvent, ArrayGridList<ChunkWrapper> chunkWrappersToGenerate, DhLitWorldGenRegion region) throws InterruptedException {
        ChunkWrapper chunkWrapper2;
        int i;
        block52: {
            ChunkWrapper chunkWrapper3;
            int i2;
            EDhApiWorldGenerationStep step;
            block51: {
                ChunkWrapper chunkWrapper4;
                int i3;
                block50: {
                    ChunkWrapper chunkWrapper5;
                    int i4;
                    block49: {
                        ChunkWrapper chunkWrapper6;
                        int i5;
                        block48: {
                            ChunkWrapper chunkWrapper7;
                            int i6;
                            block47: {
                                ChunkWrapper chunkWrapper8;
                                int i7;
                                block46: {
                                    ChunkWrapper chunkWrapper9;
                                    int i8;
                                    if (Thread.interrupted()) {
                                        return;
                                    }
                                    chunkWrappersToGenerate.forEach(chunkWrapper -> {
                                        class_2791 chunk = chunkWrapper.getChunk();
                                        if (chunk instanceof class_2839) {
                                            class_2839 protoChunk = (class_2839)chunk;
                                            protoChunk.method_17032(region.method_22336());
                                        }
                                        SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.addPosToIgnore(chunkWrapper.getChunkPos());
                                    });
                                    if (genEvent.generatorMode != EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) break block46;
                                    this.stepBiomes.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.BIOMES));
                                    int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                    for (i8 = 0; i8 < chunkWrappersToGenerate.size(); ++i8) {
                                        chunkWrapper9 = (ChunkWrapper)chunkWrappersToGenerate.get(i8);
                                        if (chunkWrapper9.getStatus() == class_2806.field_12798) continue;
                                        iChunkWrapperList.add(chunkWrapper9);
                                    }
                                    for (i8 = 0; i8 < iChunkWrapperList.size(); ++i8) {
                                        List<BeaconBeamDTO> activeBeamList;
                                        ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i8);
                                        if (centerChunkWrapper == null) continue;
                                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                                        centerChunkWrapper.createDhHeightMaps();
                                        if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                                            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                                        }
                                        if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                                        this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                                    }
                                    for (i8 = 0; i8 < iChunkWrapperList.size(); ++i8) {
                                        chunkWrapper9 = (ChunkWrapper)iChunkWrapperList.get(i8);
                                        if (chunkWrapper9 == null) continue;
                                        this.chunkSaveIgnoreTimer.schedule(new TimerTask(this, chunkWrapper9){
                                            final /* synthetic */ ChunkWrapper val$chunkWrapper;
                                            {
                                                this.val$chunkWrapper = chunkWrapper;
                                            }

                                            @Override
                                            public void run() {
                                                SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.removePosToIgnore(this.val$chunkWrapper.getChunkPos());
                                            }
                                        }, 5000L);
                                    }
                                    return;
                                }
                                step = genEvent.targetGenerationStep;
                                if (step != EDhApiWorldGenerationStep.EMPTY) break block47;
                                int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                for (i7 = 0; i7 < chunkWrappersToGenerate.size(); ++i7) {
                                    chunkWrapper8 = (ChunkWrapper)chunkWrappersToGenerate.get(i7);
                                    if (chunkWrapper8.getStatus() == class_2806.field_12798) continue;
                                    iChunkWrapperList.add(chunkWrapper8);
                                }
                                for (i7 = 0; i7 < iChunkWrapperList.size(); ++i7) {
                                    List<BeaconBeamDTO> activeBeamList;
                                    ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i7);
                                    if (centerChunkWrapper == null) continue;
                                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                                    centerChunkWrapper.createDhHeightMaps();
                                    if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                                        DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                                    }
                                    if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                                    this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                                }
                                for (i7 = 0; i7 < iChunkWrapperList.size(); ++i7) {
                                    chunkWrapper8 = (ChunkWrapper)iChunkWrapperList.get(i7);
                                    if (chunkWrapper8 == null) continue;
                                    this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
                                }
                                return;
                            }
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            this.stepStructureStart.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.STRUCTURE_START));
                            if (step != EDhApiWorldGenerationStep.STRUCTURE_START) break block48;
                            int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                            for (i6 = 0; i6 < chunkWrappersToGenerate.size(); ++i6) {
                                chunkWrapper7 = (ChunkWrapper)chunkWrappersToGenerate.get(i6);
                                if (chunkWrapper7.getStatus() == class_2806.field_12798) continue;
                                iChunkWrapperList.add(chunkWrapper7);
                            }
                            for (i6 = 0; i6 < iChunkWrapperList.size(); ++i6) {
                                List<BeaconBeamDTO> activeBeamList;
                                ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i6);
                                if (centerChunkWrapper == null) continue;
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                centerChunkWrapper.createDhHeightMaps();
                                if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                                }
                                if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                                this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                            }
                            for (i6 = 0; i6 < iChunkWrapperList.size(); ++i6) {
                                chunkWrapper7 = (ChunkWrapper)iChunkWrapperList.get(i6);
                                if (chunkWrapper7 == null) continue;
                                this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
                            }
                            return;
                        }
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        this.stepStructureReference.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.STRUCTURE_REFERENCE));
                        if (step != EDhApiWorldGenerationStep.STRUCTURE_REFERENCE) break block49;
                        int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                        for (i5 = 0; i5 < chunkWrappersToGenerate.size(); ++i5) {
                            chunkWrapper6 = (ChunkWrapper)chunkWrappersToGenerate.get(i5);
                            if (chunkWrapper6.getStatus() == class_2806.field_12798) continue;
                            iChunkWrapperList.add(chunkWrapper6);
                        }
                        for (i5 = 0; i5 < iChunkWrapperList.size(); ++i5) {
                            List<BeaconBeamDTO> activeBeamList;
                            ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i5);
                            if (centerChunkWrapper == null) continue;
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            centerChunkWrapper.createDhHeightMaps();
                            if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                                DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                            }
                            if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                            this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                        }
                        for (i5 = 0; i5 < iChunkWrapperList.size(); ++i5) {
                            chunkWrapper6 = (ChunkWrapper)iChunkWrapperList.get(i5);
                            if (chunkWrapper6 == null) continue;
                            this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
                        }
                        return;
                    }
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    this.stepBiomes.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.BIOMES));
                    if (step != EDhApiWorldGenerationStep.BIOMES) break block50;
                    int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                    for (i4 = 0; i4 < chunkWrappersToGenerate.size(); ++i4) {
                        chunkWrapper5 = (ChunkWrapper)chunkWrappersToGenerate.get(i4);
                        if (chunkWrapper5.getStatus() == class_2806.field_12798) continue;
                        iChunkWrapperList.add(chunkWrapper5);
                    }
                    for (i4 = 0; i4 < iChunkWrapperList.size(); ++i4) {
                        List<BeaconBeamDTO> activeBeamList;
                        ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i4);
                        if (centerChunkWrapper == null) continue;
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        centerChunkWrapper.createDhHeightMaps();
                        if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                        }
                        if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                        this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                    }
                    for (i4 = 0; i4 < iChunkWrapperList.size(); ++i4) {
                        chunkWrapper5 = (ChunkWrapper)iChunkWrapperList.get(i4);
                        if (chunkWrapper5 == null) continue;
                        this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
                    }
                    return;
                }
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                this.stepNoise.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.NOISE));
                if (step != EDhApiWorldGenerationStep.NOISE) break block51;
                int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                for (i3 = 0; i3 < chunkWrappersToGenerate.size(); ++i3) {
                    chunkWrapper4 = (ChunkWrapper)chunkWrappersToGenerate.get(i3);
                    if (chunkWrapper4.getStatus() == class_2806.field_12798) continue;
                    iChunkWrapperList.add(chunkWrapper4);
                }
                for (i3 = 0; i3 < iChunkWrapperList.size(); ++i3) {
                    List<BeaconBeamDTO> activeBeamList;
                    ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i3);
                    if (centerChunkWrapper == null) continue;
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    centerChunkWrapper.createDhHeightMaps();
                    if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                        DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                    }
                    if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                    this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
                }
                for (i3 = 0; i3 < iChunkWrapperList.size(); ++i3) {
                    chunkWrapper4 = (ChunkWrapper)iChunkWrapperList.get(i3);
                    if (chunkWrapper4 == null) continue;
                    this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
                }
                return;
            }
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            this.stepSurface.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.SURFACE));
            if (step != EDhApiWorldGenerationStep.SURFACE) break block52;
            int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i2 = 0; i2 < chunkWrappersToGenerate.size(); ++i2) {
                chunkWrapper3 = (ChunkWrapper)chunkWrappersToGenerate.get(i2);
                if (chunkWrapper3.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper3);
            }
            for (i2 = 0; i2 < iChunkWrapperList.size(); ++i2) {
                List<BeaconBeamDTO> activeBeamList;
                ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i2);
                if (centerChunkWrapper == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                centerChunkWrapper.createDhHeightMaps();
                if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                }
                if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
            }
            for (i2 = 0; i2 < iChunkWrapperList.size(); ++i2) {
                chunkWrapper3 = (ChunkWrapper)iChunkWrapperList.get(i2);
                if (chunkWrapper3 == null) continue;
                this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
            }
            return;
        }
        try {
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            this.stepFeatures.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.FEATURES));
        }
        catch (Throwable throwable) {
            ChunkWrapper chunkWrapper10;
            int i9;
            int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i9 = 0; i9 < chunkWrappersToGenerate.size(); ++i9) {
                chunkWrapper10 = (ChunkWrapper)chunkWrappersToGenerate.get(i9);
                if (chunkWrapper10.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper10);
            }
            for (i9 = 0; i9 < iChunkWrapperList.size(); ++i9) {
                List<BeaconBeamDTO> activeBeamList;
                ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i9);
                if (centerChunkWrapper == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                centerChunkWrapper.createDhHeightMaps();
                if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
                }
                if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
                this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
            }
            for (i9 = 0; i9 < iChunkWrapperList.size(); ++i9) {
                chunkWrapper10 = (ChunkWrapper)iChunkWrapperList.get(i9);
                if (chunkWrapper10 == null) continue;
                this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
            }
            throw throwable;
        }
        int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
        for (i = 0; i < chunkWrappersToGenerate.size(); ++i) {
            chunkWrapper2 = (ChunkWrapper)chunkWrappersToGenerate.get(i);
            if (chunkWrapper2.getStatus() == class_2806.field_12798) continue;
            iChunkWrapperList.add(chunkWrapper2);
        }
        for (i = 0; i < iChunkWrapperList.size(); ++i) {
            List<BeaconBeamDTO> activeBeamList;
            ChunkWrapper centerChunkWrapper = (ChunkWrapper)iChunkWrapperList.get(i);
            if (centerChunkWrapper == null) continue;
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            centerChunkWrapper.createDhHeightMaps();
            if (!centerChunkWrapper.isDhBlockLightingCorrect()) {
                DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunkWrapper, iChunkWrapperList, maxSkyLight);
            }
            if ((activeBeamList = centerChunkWrapper.getAllActiveBeacons(iChunkWrapperList)).isEmpty()) continue;
            this.dhServerLevel.updateBeaconBeamsForChunkPos(centerChunkWrapper.getChunkPos(), activeBeamList);
        }
        for (i = 0; i < iChunkWrapperList.size(); ++i) {
            chunkWrapper2 = (ChunkWrapper)iChunkWrapperList.get(i);
            if (chunkWrapper2 == null) continue;
            this.chunkSaveIgnoreTimer.schedule(new /* invalid duplicate definition of identical inner class */, 5000L);
        }
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, int border) {
        return new ArrayGridList<T>(total, border, total.gridSize - border);
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, EDhApiWorldGenerationStep step) {
        return BatchGenerationEnvironment.GetCutoutFrom(total, (Integer)WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP.get((Object)step));
    }

    @Override
    public CompletableFuture<Void> queueGenEvent(int minX, int minZ, int chunkWidthCount, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep targetStep, ExecutorService worldGeneratorThreadPool, Consumer<IChunkWrapper> resultConsumer) {
        GenerationEvent genEvent = GenerationEvent.start(new DhChunkPos(minX, minZ), chunkWidthCount, this, generatorMode, targetStep, resultConsumer, worldGeneratorThreadPool);
        this.generationEventQueue.add(genEvent);
        return genEvent.future;
    }

    @Override
    public void close() {
        LOGGER.info("Closing [" + BatchGenerationEnvironment.class.getSimpleName() + "]", new Object[0]);
        Iterator<GenerationEvent> genEventIter = this.generationEventQueue.iterator();
        while (genEventIter.hasNext()) {
            GenerationEvent event = genEventIter.next();
            event.future.cancel(true);
            genEventIter.remove();
        }
        this.chunkFileReader.close();
    }

    public static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("[" + BatchGenerationEnvironment.class.getSimpleName() + "] task interrupted.");
        }
    }

    static {
        EXCEPTION_TIMER_RESET_TIME = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        isDhWorldGenThreadRef = new ThreadLocal();
        boolean isTerraFirmaCraftPresent = false;
        try {
            Class.forName("net.dries007.tfc.world.TFCChunkGenerator");
            isTerraFirmaCraftPresent = true;
            LOGGER.info("TerraFirmaCraft detected.", new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EDhApiWorldGenerationStep.EMPTY, (Object)1);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_START, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_REFERENCE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.BIOMES, (Object)(isTerraFirmaCraftPresent ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.NOISE, (Object)(isTerraFirmaCraftPresent ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.SURFACE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIQUID_CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.FEATURES, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIGHT, (Object)0);
        WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP = builder.build();
        MAX_WORLD_GEN_CHUNK_BORDER_NEEDED = 0;
    }

    @FunctionalInterface
    public static interface IEmptyChunkRetrievalFunc {
        public class_2791 getChunk(int var1, int var2);
    }
}

