/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.inventoryaccessport;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.inventoryaccessport.InventoryAccessPortBlock;
import com.hlysine.create_connected.content.inventoryaccessport.WrappedItemHandler;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="create_connected")
public class InventoryAccessPortBlockEntity
extends SmartBlockEntity {
    protected IItemHandler itemCapability = null;
    private InvManipulationBehaviour observedInventory;
    private boolean powered = false;

    public InventoryAccessPortBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.updateConnectedInventory();
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CCBlockEntityTypes.INVENTORY_ACCESS_PORT.get(), (be, context) -> {
            if (be.itemCapability == null) {
                be.refreshCapability();
            }
            return be.itemCapability;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection((BlockState)s));
        this.observedInventory = new InvManipulationBehaviour((SmartBlockEntity)this, towardBlockFacing);
        behaviours.add((BlockEntityBehaviour)this.observedInventory);
    }

    public boolean isAttached() {
        return !this.powered && this.observedInventory.hasInventory() && !(this.observedInventory.getInventory() instanceof WrappedItemHandler);
    }

    public void updateConnectedInventory() {
        this.observedInventory.findNewCapability();
        boolean previouslyPowered = this.powered;
        assert (this.level != null);
        this.powered = this.level.hasNeighborSignal(this.worldPosition);
        if (this.powered != previouslyPowered) {
            this.notifyUpdate();
        }
        if (this.isAttached() != ((Boolean)this.getBlockState().getValue((Property)InventoryAccessPortBlock.ATTACHED)).booleanValue()) {
            BlockState state = (BlockState)this.getBlockState().cycle((Property)InventoryAccessPortBlock.ATTACHED);
            this.level.setBlockAndUpdate(this.worldPosition, state);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.powered = tag.getBoolean("Powered");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putBoolean("Powered", this.powered);
    }

    private IItemHandler getConnectedItemHandler() {
        if (this.powered) {
            return null;
        }
        IItemHandler handler = (IItemHandler)this.observedInventory.getInventory();
        if (handler instanceof WrappedItemHandler) {
            return null;
        }
        return handler;
    }

    private void refreshCapability() {
        this.itemCapability = new InventoryAccessHandler();
        this.invalidateCapabilities();
    }

    private class InventoryAccessHandler
    implements WrappedItemHandler {
        private final ThreadLocal<Boolean> recursionGuard = ThreadLocal.withInitial(() -> false);

        private InventoryAccessHandler() {
        }

        private <T> T preventRecursion(Supplier<T> value, T defaultValue) {
            if (this.recursionGuard.get().booleanValue()) {
                return defaultValue;
            }
            this.recursionGuard.set(true);
            T result = value.get();
            this.recursionGuard.set(false);
            return result;
        }

        public int getSlots() {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? 0 : handler.getSlots();
            }, 0);
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? ItemStack.EMPTY : handler.getStackInSlot(i);
            }, ItemStack.EMPTY);
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? itemStack : handler.insertItem(i, itemStack, b);
            }, itemStack);
        }

        @NotNull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? ItemStack.EMPTY : handler.extractItem(i, i1, b);
            }, ItemStack.EMPTY);
        }

        public int getSlotLimit(int i) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? 0 : handler.getSlotLimit(i);
            }, 0);
        }

        public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler != null && handler.isItemValid(i, itemStack);
            }, false);
        }
    }
}

