/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import com.simibubi.create.foundation.item.SmartInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PackagePortMenu
extends MenuBase<PackagePortBlockEntity> {
    public PackagePortMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public PackagePortMenu(MenuType<?> type, int id, Inventory inv, PackagePortBlockEntity be) {
        super(type, id, inv, be);
        BlockEntityBehaviour.get(be, AnimatedContainerBehaviour.TYPE).startOpen(this.player);
    }

    public static PackagePortMenu create(int id, Inventory inv, PackagePortBlockEntity be) {
        return new PackagePortMenu((MenuType)AllMenuTypes.PACKAGE_PORT.get(), id, inv, be);
    }

    @Override
    protected PackagePortBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockPos readBlockPos = extraData.readBlockPos();
        BlockEntity blockEntity = world.getBlockEntity(readBlockPos);
        if (blockEntity instanceof PackagePortBlockEntity) {
            PackagePortBlockEntity ppbe = (PackagePortBlockEntity)blockEntity;
            return ppbe;
        }
        return null;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem().copy();
        ItemStack moved = stack.copy();
        int size = ((PackagePortBlockEntity)this.contentHolder).inventory.getSlots();
        if (index < size ? !this.moveItemStackTo(stack, size, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, size, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setByPlayer(stack.copy());
        }
        return moved;
    }

    @Override
    protected void initAndReadInventory(PackagePortBlockEntity contentHolder) {
    }

    @Override
    protected void addSlots() {
        SmartInventory inventory = ((PackagePortBlockEntity)this.contentHolder).inventory;
        int x = 27;
        int y = 9;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, row * 9 + col, x + col * 18, y + row * 18));
            }
        }
        this.addPlayerSlots(38, 108);
    }

    @Override
    protected void saveData(PackagePortBlockEntity contentHolder) {
    }

    @Override
    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!playerIn.level().isClientSide) {
            BlockEntityBehaviour.get((BlockEntity)this.contentHolder, AnimatedContainerBehaviour.TYPE).stopOpen(playerIn);
        }
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack stackInSlot;
        Slot slot;
        boolean success = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = (Slot)this.slots.get(i);
                stackInSlot = slot.getItem();
                if (!stackInSlot.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                    int maxSize;
                    int totalCount = stackInSlot.getCount() + stack.getCount();
                    if (totalCount <= (maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        slot.setByPlayer(stackInSlot.copyWithCount(totalCount));
                        success = true;
                    } else if (stackInSlot.getCount() < maxSize) {
                        stack.shrink(maxSize - stackInSlot.getCount());
                        slot.setByPlayer(stackInSlot.copyWithCount(maxSize));
                        success = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = (Slot)this.slots.get(i);
                stackInSlot = slot.getItem();
                if (stackInSlot.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    success = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return success;
    }
}

