/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.client.gui.tooltip;

import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.Fraction;

@OnlyIn(value=Dist.CLIENT)
public class CustomBundleTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.withDefaultNamespace((String)"container/bundle/background");
    private static final int field_32381 = 4;
    private static final int field_32382 = 1;
    private static final int WIDTH_PER_COLUMN = 18;
    private static final int HEIGHT_PER_ROW = 20;
    private final CustomBundleContentsComponent customBundleContents;

    public CustomBundleTooltipComponent(CustomBundleContentsComponent customBundleContents) {
        this.customBundleContents = customBundleContents;
    }

    public int getHeight() {
        return this.getRowsHeight() + 4;
    }

    public int getWidth(Font textRenderer) {
        return this.getColumnsWidth();
    }

    private int getColumnsWidth() {
        return this.getColumns() * 18 + 2;
    }

    private int getRowsHeight() {
        return this.getRows() * 20 + 2;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        int i = this.getColumns();
        int j = this.getRows();
        context.blitSprite(BACKGROUND_TEXTURE, x, y, this.getColumnsWidth(), this.getRowsHeight());
        boolean bl = this.customBundleContents.getOccupancy().compareTo(Fraction.ONE) >= 0;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = x + m * 18 + 1;
                int o = y + l * 20 + 1;
                this.drawSlot(n, o, k++, bl, context, textRenderer);
            }
        }
    }

    private void drawSlot(int x, int y, int index, boolean shouldBlock, GuiGraphics context, Font textRenderer) {
        if (index >= this.customBundleContents.size()) {
            this.draw(context, x, y, shouldBlock ? SlotSprite.BLOCKED_SLOT : SlotSprite.SLOT);
        } else {
            ItemStack itemStack = this.customBundleContents.get(index);
            this.draw(context, x, y, SlotSprite.SLOT);
            context.renderItem(itemStack, x + 1, y + 1, index);
            context.renderItemDecorations(textRenderer, itemStack, x + 1, y + 1);
            if (index == 0) {
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)context, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void draw(GuiGraphics context, int x, int y, SlotSprite sprite) {
        context.blitSprite(sprite.texture, x, y, 0, sprite.width, sprite.height);
    }

    private int getColumns() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.customBundleContents.size() + 1.0)));
    }

    private int getRows() {
        return (int)Math.ceil(((double)this.customBundleContents.size() + 1.0) / (double)this.getColumns());
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SlotSprite {
        BLOCKED_SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/blocked_slot"), 18, 20),
        SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/slot"), 18, 20);

        public final ResourceLocation texture;
        public final int width;
        public final int height;

        private SlotSprite(ResourceLocation texture, int width, int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
        }
    }
}

