/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.component.type;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public record CustomBundleContentsComponent(Content content, Fraction occupancy, int size_multiplier) implements TooltipComponent
{
    public static final CustomBundleContentsComponent DEFAULT = new CustomBundleContentsComponent(List.of(), 1);
    public static final Codec<CustomBundleContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Content.CODEC.fieldOf("content").forGetter(component -> component.content), (App)Codec.INT.optionalFieldOf("size_multiplier", (Object)1).forGetter(component -> component.size_multiplier)).apply((Applicative)instance, CustomBundleContentsComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomBundleContentsComponent> PACKET_CODEC = StreamCodec.composite(Content.PACKET_CODEC, component -> component.content, (StreamCodec)ByteBufCodecs.VAR_INT, component -> component.size_multiplier, CustomBundleContentsComponent::new);
    private static final Fraction NESTED_BUNDLE_OCCUPANCY = Fraction.getFraction((int)1, (int)16);

    CustomBundleContentsComponent(List<ItemStack> stacks, Fraction occupancy, int size_multiplier) {
        this(new Content(stacks), occupancy, size_multiplier);
    }

    CustomBundleContentsComponent(List<ItemStack> stacks, int size_multiplier) {
        this(new Content(stacks), CustomBundleContentsComponent.calculateOccupancy(stacks, size_multiplier), size_multiplier);
    }

    public CustomBundleContentsComponent(Content content, int size_multiplier) {
        this(content, CustomBundleContentsComponent.calculateOccupancy(content.stacks, size_multiplier), size_multiplier);
    }

    public CustomBundleContentsComponent(int size_multiplier) {
        this(Content.DEFAULT, size_multiplier);
    }

    public static Builder builder() {
        return new Builder(DEFAULT);
    }

    private static Fraction calculateOccupancy(List<ItemStack> stacks, int size_multiplier) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemStack : stacks) {
            fraction = fraction.add(CustomBundleContentsComponent.getOccupancy(itemStack, size_multiplier).multiplyBy(Fraction.getFraction((int)itemStack.getCount(), (int)1)));
        }
        return fraction;
    }

    static Fraction getOccupancy(ItemStack stack, int size_multiplier) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            return NESTED_BUNDLE_OCCUPANCY.add(customBundleContentsComponent.getOccupancy());
        }
        List list = (List)stack.getOrDefault(DataComponents.BEES, List.of());
        return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction((int)1, (int)(stack.getMaxStackSize() * size_multiplier));
    }

    public ItemStack get(int index) {
        return this.content.stacks.get(index);
    }

    public Stream<ItemStack> stream() {
        return this.content.stacks.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> iterate() {
        return this.content.stacks;
    }

    public Iterable<ItemStack> iterateCopy() {
        return Lists.transform(this.content.stacks, ItemStack::copy);
    }

    public int size() {
        return this.content.stacks.size();
    }

    public int sizeMultiplier() {
        return this.size_multiplier;
    }

    public Fraction getOccupancy() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.content.stacks.isEmpty();
    }

    public record Content(List<ItemStack> stacks) {
        public static final Content DEFAULT = new Content(List.of());
        public static final Codec<Content> CODEC = ItemStack.CODEC.listOf().xmap(Content::new, component -> component.stacks);
        public static final StreamCodec<RegistryFriendlyByteBuf, Content> PACKET_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(Content::new, content -> content.stacks);

        public Content(List<ItemStack> stacks) {
            this.stacks = new ArrayList<ItemStack>(stacks);
        }
    }

    public static class Builder {
        private Content content;
        private Fraction occupancy;
        private int size_multiplier;

        public Builder(CustomBundleContentsComponent base) {
            this.content = new Content(base.content.stacks);
            this.occupancy = base.occupancy;
            this.size_multiplier = base.size_multiplier;
        }

        public Builder clear() {
            this.content.stacks.clear();
            this.occupancy = Fraction.ZERO;
            return this;
        }

        private int addInternal(ItemStack stack) {
            if (!stack.isStackable()) {
                return -1;
            }
            for (int i = 0; i < this.content.stacks.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.content.stacks.get(i), (ItemStack)stack) || this.content.stacks.get(i).getCount() >= this.content.stacks.get(i).getMaxStackSize()) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAllowed(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.occupancy);
            return Math.max(fraction.divideBy(CustomBundleContentsComponent.getOccupancy(stack, this.size_multiplier)).intValue(), 0);
        }

        public int add(ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                int i = Math.min(stack.getCount(), this.getMaxAllowed(stack));
                if (i == 0) {
                    return 0;
                }
                this.occupancy = this.occupancy.add(CustomBundleContentsComponent.getOccupancy(stack, this.size_multiplier).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.addInternal(stack);
                if (j != -1) {
                    int count;
                    ItemStack itemStack = this.content.stacks.remove(j);
                    int maxCount = itemStack.getMaxStackSize();
                    int countDiff = maxCount - (count = itemStack.getCount());
                    if (i <= countDiff) {
                        ItemStack itemStack2 = itemStack.copyWithCount(itemStack.getCount() + i);
                        stack.shrink(i);
                        this.content.stacks.add(0, itemStack2);
                    } else {
                        ItemStack itemStack2 = itemStack.copyWithCount(itemStack.getCount() + countDiff);
                        this.content.stacks.add(0, itemStack2);
                        ItemStack itemStack3 = stack.copyWithCount(i - countDiff);
                        this.content.stacks.add(0, itemStack3);
                        stack.shrink(i);
                    }
                } else {
                    this.content.stacks.add(0, stack.split(i));
                }
                return i;
            }
            return 0;
        }

        public int add(Slot slot, Player player) {
            ItemStack itemStack = slot.getItem();
            int i = this.getMaxAllowed(itemStack);
            return this.add(slot.safeTake(itemStack.getCount(), i, player));
        }

        @Nullable
        public ItemStack removeFirst() {
            if (this.content.stacks.isEmpty()) {
                return null;
            }
            ItemStack itemStack = this.content.stacks.remove(0).copy();
            this.occupancy = this.occupancy.subtract(CustomBundleContentsComponent.getOccupancy(itemStack, this.size_multiplier).multiplyBy(Fraction.getFraction((int)itemStack.getCount(), (int)1)));
            return itemStack;
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public Builder size_multiplier(int size_multiplier) {
            this.size_multiplier = size_multiplier;
            return this;
        }

        public CustomBundleContentsComponent build() {
            return new CustomBundleContentsComponent(List.copyOf(this.content.stacks), this.occupancy, this.size_multiplier);
        }
    }
}

