/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.item;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import com.github.theredbrain.bundleapi.item.tooltip.CustomBundleTooltipData;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class CustomBundleItem
extends Item {
    private static final int ITEM_BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);
    public static final HashSet<CustomBundleItem> instances = new HashSet();
    private final TagKey<Item> tag;

    public CustomBundleItem(@Nullable TagKey<Item> tag, Item.Properties settings) {
        super(settings);
        this.tag = tag;
        instances.add(this);
    }

    public CustomBundleItem(Item.Properties settings) {
        this(null, settings);
    }

    public static float getAmountFilled(ItemStack stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.getOrDefault(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return customBundleContentsComponent.getOccupancy().floatValue();
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickType, Player player) {
        int i;
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent == null) {
            return false;
        }
        ItemStack itemStack = slot.getItem();
        CustomBundleContentsComponent.Builder builder = new CustomBundleContentsComponent.Builder(customBundleContentsComponent);
        if (itemStack.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            ItemStack itemStack2 = builder.removeFirst();
            if (itemStack2 != null) {
                ItemStack itemStack3 = slot.safeInsert(itemStack2);
                builder.add(itemStack3);
            }
        } else if (itemStack.getItem().canFitInsideContainerItems() && (this.tag == null || itemStack.is(this.tag)) && (i = builder.add(slot, player)) > 0) {
            this.playInsertSound((Entity)player);
        }
        stack.set(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)builder.build());
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.SECONDARY && slot.allowModification(player)) {
            int i;
            CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
            if (customBundleContentsComponent == null) {
                return false;
            }
            CustomBundleContentsComponent.Builder builder = new CustomBundleContentsComponent.Builder(customBundleContentsComponent);
            if (otherStack.isEmpty()) {
                ItemStack itemStack = builder.removeFirst();
                if (itemStack != null) {
                    this.playRemoveOneSound((Entity)player);
                    cursorStackReference.set(itemStack);
                }
            } else if ((this.tag == null || otherStack.is(this.tag)) && (i = builder.add(otherStack)) > 0) {
                this.playInsertSound((Entity)player);
            }
            stack.set(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)builder.build());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (CustomBundleItem.dropAllBundledItems(itemStack, user)) {
            this.playDropContentsSound((Entity)user);
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public boolean isBarVisible(ItemStack stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.getOrDefault(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return customBundleContentsComponent.getOccupancy().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.getOrDefault(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)customBundleContentsComponent.getOccupancy(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return ITEM_BAR_COLOR;
    }

    private static boolean dropAllBundledItems(ItemStack stack, Player player) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null && !customBundleContentsComponent.isEmpty()) {
            stack.set(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)new CustomBundleContentsComponent.Builder(customBundleContentsComponent).clear().build());
            if (player instanceof ServerPlayer) {
                customBundleContentsComponent.iterateCopy().forEach(stackx -> player.drop(stackx, true));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT)).map(CustomBundleTooltipData::new) : Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            int bundleMaxSize = customBundleContentsComponent.sizeMultiplier() * 64;
            int i = Mth.mulAndTruncate((Fraction)customBundleContentsComponent.getOccupancy(), (int)bundleMaxSize);
            tooltip.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, bundleMaxSize}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onDestroyed(ItemEntity entity) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)entity.getItem().get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            entity.getItem().set(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)new CustomBundleContentsComponent.Builder(customBundleContentsComponent).clear().build());
            ItemUtils.onContainerDestroyed((ItemEntity)entity, customBundleContentsComponent.iterateCopy());
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

