/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.fluid.builder;

import dev.averageanime.neoforge.CreateFood;
import dev.averageanime.neoforge.fluid.builder.CustomFluidType;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;

public class CustomFluid {
    private final String name;
    private Vector3f fogColor = null;
    private int density = 1400;
    private int viscosity = 1500;
    private int lightLevel = 0;
    private int slopeFindDistance = 4;
    private int levelDecreasePerBlock = 3;
    private SoundEvent drinkSound = SoundEvents.HONEY_DRINK;

    public CustomFluid(String name) {
        this.name = name;
    }

    public CustomFluid color(float r, float g, float b) {
        this.fogColor = new Vector3f(r, g, b);
        return this;
    }

    public CustomFluid color(Vector3f color) {
        this.fogColor = color;
        return this;
    }

    public CustomFluid physics(int density, int viscosity) {
        this.density = density;
        this.viscosity = viscosity;
        return this;
    }

    public CustomFluid flow(int slopeFindDistance, int levelDecreasePerBlock) {
        this.slopeFindDistance = slopeFindDistance;
        this.levelDecreasePerBlock = levelDecreasePerBlock;
        return this;
    }

    public CustomFluid lightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public CustomFluid drinkSound(SoundEvent sound) {
        this.drinkSound = sound;
        return this;
    }

    public CustomFluidType build() {
        Vector3f finalColor = this.fogColor;
        if (finalColor == null) {
            finalColor = CustomFluid.extractColorFromTexture(this.name);
        }
        FluidType.Properties properties = FluidType.Properties.create().lightLevel(this.lightLevel).sound(SoundAction.get((String)"drink"), this.drinkSound).density(this.density).viscosity(this.viscosity);
        return new CustomFluidType(this.name, finalColor, properties, this.slopeFindDistance, this.levelDecreasePerBlock);
    }

    private static Vector3f extractColorFromTexture(String fluidName) {
        try {
            String texturePath = "/assets/createfood/textures/fluid/" + fluidName + "_still.png";
            InputStream stream = CustomFluid.class.getResourceAsStream(texturePath);
            if (stream == null) {
                CreateFood.LOGGER.warn("Could not find texture for fluid: {} at path: {}", (Object)fluidName, (Object)texturePath);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            if (image == null) {
                CreateFood.LOGGER.warn("Could not read texture for fluid: {}", (Object)fluidName);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            long totalR = 0L;
            long totalG = 0L;
            long totalB = 0L;
            long totalAlpha = 0L;
            int width = image.getWidth();
            int height = image.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = image.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    totalR += (long)(red * alpha);
                    totalG += (long)(green * alpha);
                    totalB += (long)(blue * alpha);
                    totalAlpha += (long)alpha;
                }
            }
            if (totalAlpha == 0L) {
                CreateFood.LOGGER.warn("Texture for fluid {} is fully transparent", (Object)fluidName);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            float r = (float)(totalR / totalAlpha) / 255.0f;
            float g = (float)(totalG / totalAlpha) / 255.0f;
            float b = (float)(totalB / totalAlpha) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (Exception e) {
            CreateFood.LOGGER.error("Error extracting color from texture for fluid: {}", (Object)fluidName, (Object)e);
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }
}

