/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.item.tooltip;

import dev.averageanime.CommonClass;
import dev.averageanime.neoforge.config.ModConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="createfood", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class CustomTooltips {
    private static final String TOOLTIP_PREFIX = "tooltip.createfood.";
    private static final String TOOLTIP_SUFFIX = "_ingredient";
    private static Map<String, String[]> customTooltipMap = null;

    public static void addTooltip(List<Component> tooltips, String modName, String ... ingredientLines) {
        boolean shouldShow;
        boolean bl = shouldShow = (Boolean)ModConfig.REQUIRE_SHIFT_FOR_TOOLTIPS.get() == false || Screen.hasShiftDown();
        if (modName != null && ((Boolean)ModConfig.SHOW_COMPATIBILITY.get()).booleanValue()) {
            tooltips.add((Component)Component.translatable((String)modName).withStyle(ChatFormatting.BLUE));
        }
        if (shouldShow) {
            if (ingredientLines != null && ((Boolean)ModConfig.SHOW_INGREDIENTS.get()).booleanValue()) {
                tooltips.add((Component)Component.translatable((String)"tooltip.createfood.ingredients").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
                for (String line : ingredientLines) {
                    if (line == null || line.isEmpty()) continue;
                    tooltips.add((Component)Component.translatable((String)line).withStyle(ChatFormatting.GRAY));
                }
            }
        } else if (modName == null && ((Boolean)ModConfig.REQUIRE_SHIFT_FOR_TOOLTIPS.get()).booleanValue()) {
            tooltips.add((Component)Component.translatable((String)"tooltip.createfood.hold").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"tooltip.createfood.shift").withStyle(ChatFormatting.GRAY)).append((Component)Component.translatable((String)"tooltip.createfood.info").withStyle(ChatFormatting.DARK_GRAY)));
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        String[] tooltipKeys;
        ItemStack stack = event.getItemStack();
        List tooltips = event.getToolTip();
        String itemId = stack.getItem().builtInRegistryHolder().key().location().toString();
        CustomTooltips.loadCustomTooltips();
        if (customTooltipMap.containsKey(itemId) && (tooltipKeys = customTooltipMap.get(itemId)) != null && tooltipKeys.length > 0) {
            CustomTooltips.addTooltip(tooltips, null, tooltipKeys);
        }
    }

    private static void loadCustomTooltips() {
        if (customTooltipMap != null) {
            return;
        }
        customTooltipMap = new HashMap<String, String[]>();
        List configEntries = (List)ModConfig.CUSTOM_TOOLTIPS.get();
        for (String entry : configEntries) {
            try {
                String[] parts = entry.split("\\|", 2);
                if (parts.length < 2) {
                    CommonClass.LOGGER.warn("Invalid custom tooltip entry (not enough parts): {}", (Object)entry);
                    continue;
                }
                String itemId = parts[0].trim();
                String[] tooltipKeys = null;
                String tooltipsPart = parts[1].trim();
                if (!tooltipsPart.isEmpty()) {
                    String[] shortKeys = tooltipsPart.split(",");
                    tooltipKeys = new String[shortKeys.length];
                    for (int i = 0; i < shortKeys.length; ++i) {
                        String shortKey = shortKeys[i].trim();
                        if (shortKey.isEmpty()) continue;
                        tooltipKeys[i] = TOOLTIP_PREFIX + shortKey + TOOLTIP_SUFFIX;
                    }
                }
                customTooltipMap.put(itemId, tooltipKeys);
            }
            catch (Exception e) {
                CommonClass.LOGGER.error("Failed to parse custom tooltip entry: {}", (Object)entry, (Object)e);
            }
        }
    }
}

