/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import jeresources.api.restrictions.Restriction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DimensionRestriction {
    public static final DimensionRestriction OVERWORLD = new DimensionRestriction((ResourceKey<Level>)Level.OVERWORLD);
    public static final DimensionRestriction NETHER = new DimensionRestriction((ResourceKey<Level>)Level.NETHER);
    public static final DimensionRestriction END = new DimensionRestriction((ResourceKey<Level>)Level.END);
    public static final DimensionRestriction NONE = new DimensionRestriction();
    private Restriction.Type type;
    private ResourceKey<Level> dimension;

    private DimensionRestriction() {
        this.type = Restriction.Type.NONE;
    }

    public DimensionRestriction(ResourceKey<Level> type) {
        this(Restriction.Type.WHITELIST, type);
    }

    public DimensionRestriction(Restriction.Type type, ResourceKey<Level> dimension) {
        this.type = type;
        this.dimension = dimension;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionRestriction) {
            DimensionRestriction other = (DimensionRestriction)obj;
            return this.type == other.type && this.dimension.equals(other.dimension);
        }
        return false;
    }

    public String toString() {
        return "Dimension: " + (String)(this.type == Restriction.Type.NONE ? "None" : this.type.name() + " " + this.dimension.toString());
    }

    public int hashCode() {
        return this.type == Restriction.Type.NONE ? super.hashCode() : this.type.hashCode() ^ this.dimension.hashCode();
    }

    public String getDimensionName() {
        return this.type == Restriction.Type.NONE ? "all" : this.dimension.location().toString();
    }
}

