/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.worldgen;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.WorldGenEntry;
import jeresources.util.RegistryHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class WorldGenTooltip
implements IRecipeSlotTooltipCallback {
    private final WorldGenEntry entry;

    public WorldGenTooltip(WorldGenEntry entry) {
        this.entry = entry;
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
        tooltip.addAll(this.getItemStackTooltip(recipeSlotView.getSlotName().orElse(null), (ItemStack)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
    }

    private List<Component> getItemStackTooltip(String slotName, ItemStack itemStack) {
        LinkedList<Object> tooltip = new LinkedList<Object>();
        if (itemStack != null && slotName != null && slotName.equals("oreSlot")) {
            List<String> biomes;
            if (this.entry.isSilkTouchNeeded()) {
                tooltip.add(Conditional.silkTouch.toString());
            }
            if ((biomes = this.entry.getBiomeRestrictions()).size() > 0) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.biomes", new Object[0]) + ":");
                tooltip.addAll(biomes);
            }
            if (Settings.showDevData) {
                tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.averageChunk", new Object[0]) + ":");
                tooltip.add("" + this.entry.getAverageBlockCountPerChunk());
            }
        } else {
            tooltip.add(TranslationHelper.translateAndFormat("jer.worldgen.average", new Object[0]));
            for (LootDrop dropItem : this.entry.getLootDrops(itemStack)) {
                Object line = " - ";
                line = dropItem.fortuneLevel > 0 ? (String)line + Enchantment.getFullname(RegistryHelper.getHolder(Registries.ENCHANTMENT, Enchantments.FORTUNE), (int)dropItem.fortuneLevel).getString() : (String)line + TranslationHelper.translateAndFormat("jer.worldgen.base", new Object[0]);
                if (dropItem.chance < 1.0f) {
                    line = (String)line + " " + TranslationHelper.translateAndFormat("jer.worldgen.chance", dropItem.formatChance() + "%");
                }
                line = dropItem.minDrop == dropItem.maxDrop ? (String)line + ": " + dropItem.minDrop : (String)line + ": " + dropItem.minDrop + " - " + dropItem.maxDrop;
                if (dropItem.isAffectedBy(Conditional.affectedByFortune)) {
                    line = (String)line + " " + TranslationHelper.translateAndFormat("jer.worldgen.affectedByFortune", new Object[0]);
                }
                tooltip.add(line);
            }
        }
        return tooltip.stream().map(Component::literal).collect(Collectors.toList());
    }
}

