/*
 * Decompiled with CFR 0.152.
 */
package jeresources.neoforge.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import jeresources.neoforge.config.ConfigValues;
import jeresources.util.LogHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static Config instance = new Config();
    public static final ModConfigSpec COMMON = ConfigValues.build();

    private Config() {
    }

    public void loadConfig(ModConfigSpec spec, Path path) {
        LogHelper.debug("Loading config file {}", path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        LogHelper.debug("Built TOML config for {}", path.toString());
        configData.load();
        LogHelper.debug("Loaded TOML config file {}", path.toString());
        spec.correct((CommentedConfig)configData);
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        LogHelper.debug("Loaded {} config file {}", "jeresources", configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onFileChange(ModConfigEvent.Reloading configEvent) {
        LogHelper.debug("Reloaded {} config file {}", "jeresources", configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }
}

