/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.controller;

import java.util.ArrayList;
import java.util.List;
import mod.azure.azurelibarmor.common.animation.AzAnimator;
import mod.azure.azurelibarmor.common.animation.controller.AzAbstractAnimationController;
import mod.azure.azurelibarmor.common.animation.controller.AzAnimationControllerBuilder;
import mod.azure.azurelibarmor.common.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelibarmor.common.animation.controller.AzAnimationQueue;
import mod.azure.azurelibarmor.common.animation.controller.AzBoneAnimationQueueCache;
import mod.azure.azurelibarmor.common.animation.controller.AzBoneSnapshotCache;
import mod.azure.azurelibarmor.common.animation.controller.keyframe.AzKeyframeCallbacks;
import mod.azure.azurelibarmor.common.animation.controller.keyframe.AzKeyframeManager;
import mod.azure.azurelibarmor.common.animation.controller.state.impl.AzAnimationPauseState;
import mod.azure.azurelibarmor.common.animation.controller.state.impl.AzAnimationPlayState;
import mod.azure.azurelibarmor.common.animation.controller.state.impl.AzAnimationStopState;
import mod.azure.azurelibarmor.common.animation.controller.state.impl.AzAnimationTransitionState;
import mod.azure.azurelibarmor.common.animation.controller.state.machine.AzAnimationControllerStateMachine;
import mod.azure.azurelibarmor.common.animation.dispatch.AzDispatchSide;
import mod.azure.azurelibarmor.common.animation.dispatch.command.sequence.AzAnimationSequence;
import mod.azure.azurelibarmor.common.animation.dispatch.command.stage.AzAnimationStage;
import mod.azure.azurelibarmor.common.animation.primitive.AzBakedAnimation;
import mod.azure.azurelibarmor.common.animation.primitive.AzQueuedAnimation;
import mod.azure.azurelibarmor.common.animation.property.AzAnimationProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzAnimationController<T>
extends AzAbstractAnimationController {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AzAnimationController.class);
    private final AzAnimationControllerTimer<T> controllerTimer;
    private final AzAnimationQueue animationQueue;
    private final AzAnimationControllerStateMachine<T> stateMachine;
    private final AzAnimator<?, T> animator;
    private final AzBoneAnimationQueueCache<T> boneAnimationQueueCache;
    private final AzBoneSnapshotCache boneSnapshotCache;
    private final AzKeyframeManager<T> keyframeManager;
    protected AzQueuedAnimation currentAnimation;
    private AzAnimationProperties animationProperties;
    private final AzAnimationControllerStateMachine.Context<T> cachedContext;

    public static <T> AzAnimationControllerBuilder<T> builder(AzAnimator<?, T> animator, String name) {
        return new AzAnimationControllerBuilder<T>(animator, name);
    }

    AzAnimationController(String name, AzAnimator<?, T> animator, AzAnimationProperties animationProperties, AzKeyframeCallbacks<T> keyframeCallbacks) {
        super(name);
        this.animator = animator;
        this.controllerTimer = new AzAnimationControllerTimer(this);
        this.animationProperties = animationProperties;
        this.animationQueue = new AzAnimationQueue();
        this.boneAnimationQueueCache = new AzBoneAnimationQueueCache(animator.context().boneCache());
        this.boneSnapshotCache = new AzBoneSnapshotCache();
        this.keyframeManager = new AzKeyframeManager<T>(this, this.boneAnimationQueueCache, this.boneSnapshotCache, keyframeCallbacks);
        AzAnimationControllerStateMachine.StateHolder stateHolder = new AzAnimationControllerStateMachine.StateHolder(new AzAnimationPlayState(), new AzAnimationPauseState(), new AzAnimationStopState(), new AzAnimationTransitionState());
        this.stateMachine = new AzAnimationControllerStateMachine(stateHolder, this, animator.context());
        this.stateMachine.initializeContext(this, animator.context());
        this.cachedContext = (AzAnimationControllerStateMachine.Context)this.stateMachine.getContext();
    }

    @Override
    public boolean hasAnimationFinished() {
        return super.hasAnimationFinished() && this.stateMachine.isStopped();
    }

    public List<AzQueuedAnimation> tryCreateAnimationQueue(T animatable, AzAnimationSequence sequence) {
        List<AzAnimationStage> stages = sequence.stages();
        ArrayList<AzQueuedAnimation> animations = new ArrayList<AzQueuedAnimation>();
        for (AzAnimationStage stage : stages) {
            AzBakedAnimation animation = this.animator.getAnimation(animatable, stage.name());
            if (animation == null) {
                LOGGER.warn("Unable to find animation: {} for {}", (Object)stage.name(), (Object)animatable.getClass().getSimpleName());
                return List.of();
            }
            animations.add(new AzQueuedAnimation(animation, stage.properties().playBehavior()));
        }
        return animations;
    }

    public void update() {
        this.controllerTimer.update();
        this.stateMachine.update(this.cachedContext);
        this.boneAnimationQueueCache.update(this.animationProperties.easingType());
    }

    public void run(AzDispatchSide originSide, @NotNull AzAnimationSequence sequence) {
        if (this.currentSequenceOrigin == AzDispatchSide.SERVER && originSide == AzDispatchSide.CLIENT && !this.hasAnimationFinished()) {
            return;
        }
        this.currentSequenceOrigin = originSide;
        if (this.stateMachine.isStopped()) {
            this.stateMachine.transition();
        }
        if (this.currentSequence == null || !this.currentSequence.equals(sequence)) {
            this.currentAnimation = null;
        }
        T animatable = this.animator.context().animatable();
        if (sequence.stages().isEmpty()) {
            this.stateMachine.stop();
            return;
        }
        if (!sequence.equals(this.currentSequence)) {
            List<AzQueuedAnimation> animations = this.tryCreateAnimationQueue(animatable, sequence);
            if (!animations.isEmpty()) {
                this.animationQueue.clear();
                this.animationQueue.addAll(animations);
                this.currentSequence = sequence;
                this.stateMachine.transition();
                return;
            }
            this.animationQueue.clear();
            this.currentSequence = null;
            this.stateMachine.transition();
        }
    }

    public AzAnimationProperties animationProperties() {
        return this.animationProperties;
    }

    public void setAnimationProperties(AzAnimationProperties animationProperties) {
        this.animationProperties = animationProperties;
    }

    public AzAnimationQueue animationQueue() {
        return this.animationQueue;
    }

    public AzBoneAnimationQueueCache<T> boneAnimationQueueCache() {
        return this.boneAnimationQueueCache;
    }

    public AzBoneSnapshotCache boneSnapshotCache() {
        return this.boneSnapshotCache;
    }

    public AzAnimationControllerTimer<T> controllerTimer() {
        return this.controllerTimer;
    }

    @Nullable
    public AzQueuedAnimation currentAnimation() {
        return this.currentAnimation;
    }

    public AzKeyframeManager<T> keyframeManager() {
        return this.keyframeManager;
    }

    public AzAnimationControllerStateMachine<T> stateMachine() {
        return this.stateMachine;
    }

    public void setCurrentAnimation(AzQueuedAnimation currentAnimation) {
        this.currentAnimation = currentAnimation;
        if (currentAnimation == null) {
            this.currentSequence = null;
            this.currentSequenceOrigin = null;
        }
    }
}

