/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.mixins;

import java.util.Map;
import mod.azure.azurelibarmor.common.cache.texture.AnimatableTexture;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureManager.class}, priority=900)
public abstract class TextureManagerMixin {
    @Shadow
    @Final
    private Map<ResourceLocation, AbstractTexture> byPath;

    @Shadow
    public abstract void register(ResourceLocation var1, AbstractTexture var2);

    @Inject(method={"getTexture(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/texture/AbstractTexture;"}, at={@At(value="HEAD")})
    private void wrapAnimatableTexture(ResourceLocation path, CallbackInfoReturnable<AbstractTexture> callback) {
        AbstractTexture existing = this.byPath.get(path);
        if (existing == null) {
            AnimatableTexture animatableTexture = new AnimatableTexture(path);
            this.register(path, (AbstractTexture)animatableTexture);
            if (!animatableTexture.isAnimated()) {
                this.byPath.remove(path);
            }
        }
    }
}

