/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render.layer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import java.util.function.Function;
import mod.azure.azurelibarmor.common.model.AzBone;
import mod.azure.azurelibarmor.common.render.AzRendererPipeline;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.layer.AzRenderLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;

public class AzArmorTrimLayer
implements AzRenderLayer<UUID, ItemStack> {
    public final ResourceLocation textureBaseLocation;
    public final Function<ArmorTrim, ResourceLocation> texturePermutations;

    public AzArmorTrimLayer(ResourceLocation baseTexture) {
        this(baseTexture, true);
    }

    public AzArmorTrimLayer(ResourceLocation baseTexture, boolean supportPatterns) {
        this(baseTexture, supportPatterns ? trim -> {
            TrimPattern pattern = (TrimPattern)trim.pattern().value();
            TrimMaterial material = (TrimMaterial)trim.material().value();
            String patternName = pattern.assetId().getPath();
            return ResourceLocation.fromNamespaceAndPath((String)baseTexture.getNamespace(), (String)(baseTexture.getPath() + "_" + patternName + "_" + material.assetName()));
        } : trim -> {
            TrimMaterial material = (TrimMaterial)trim.material().value();
            return ResourceLocation.fromNamespaceAndPath((String)baseTexture.getNamespace(), (String)(baseTexture.getPath() + "_" + material.assetName()));
        });
    }

    public AzArmorTrimLayer(ResourceLocation baseTexture, Function<ArmorTrim, ResourceLocation> textureLocationPermutations) {
        this.textureBaseLocation = baseTexture;
        this.texturePermutations = textureLocationPermutations;
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, ItemStack> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<UUID, ItemStack> context) {
        AzArmorRendererPipelineContext armorPipelineContext = (AzArmorRendererPipelineContext)context;
        ItemStack itemstack = armorPipelineContext.currentStack();
        if (itemstack == null) {
            return;
        }
        ArmorTrim armorTrim = (ArmorTrim)itemstack.get(DataComponents.TRIM);
        if (armorTrim == null) {
            return;
        }
        TrimPattern pattern = (TrimPattern)armorTrim.pattern().value();
        ModelManager bakery = Minecraft.getInstance().getModelManager();
        TextureAtlas armorTrimsAtlas = bakery.getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        AzRendererPipeline<UUID, ItemStack> renderPipeline = context.rendererPipeline();
        ResourceLocation trimLocation = this.texturePermutations.apply(armorTrim);
        TextureAtlasSprite sprite = armorTrimsAtlas.getSprite(trimLocation);
        RenderType renderType = Sheets.armorTrimsSheet((boolean)pattern.decal());
        VertexConsumer vertexConsumer = sprite.wrap(ItemRenderer.getArmorFoilBuffer((MultiBufferSource)context.multiBufferSource(), (RenderType)renderType, (boolean)itemstack.hasFoil()));
        if (context.renderType() != null) {
            context.setRenderType(renderType);
            context.setVertexConsumer(vertexConsumer);
            renderPipeline.reRender(context);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<UUID, ItemStack> azRendererPipelineContext, AzBone azBone) {
    }
}

