/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.stateless;

import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.network.packet.StatelessEntityPlayAnimPacket;
import software.bernie.geckolib.network.packet.StatelessEntityStopAnimPacket;

public non-sealed interface StatelessGeoEntity
extends StatelessAnimatable,
GeoEntity {
    @Override
    default public void playAnimation(RawAnimation animation) {
        StatelessGeoEntity statelessGeoEntity = this;
        if (!(statelessGeoEntity instanceof Entity)) {
            throw new ClassCastException("Cannot use StatelessGeoEntity on a non-entity animatable!");
        }
        Entity self = (Entity)statelessGeoEntity;
        if (self.level().isClientSide) {
            this.handleClientAnimationPlay(this, self.getId(), animation);
        } else {
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingEntity(new StatelessEntityPlayAnimPacket(self.getId(), false, animation), self);
        }
    }

    @Override
    default public void stopAnimation(String animation) {
        StatelessGeoEntity statelessGeoEntity = this;
        if (!(statelessGeoEntity instanceof Entity)) {
            throw new ClassCastException("Cannot use StatelessGeoEntity on a non-entity animatable!");
        }
        Entity self = (Entity)statelessGeoEntity;
        if (self.level().isClientSide) {
            this.handleClientAnimationStop(this, self.getId(), animation);
        } else {
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingEntity(new StatelessEntityStopAnimPacket(self.getId(), false, animation), self);
        }
    }
}

