/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class BuddingBushBlock
extends BushBlock {
    public static final MapCodec<BuddingBushBlock> CODEC = BuddingBushBlock.simpleCodec(BuddingBushBlock::new);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};

    public BuddingBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getBlock() instanceof FarmBlock;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.canGrowPastMaxAge() || !this.isMaxAge(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) <= this.getMaxAge() && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthSpeed = BuddingBushBlock.getGrowthSpeed(state, (BlockGetter)level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (this.isMaxAge(state)) {
                this.growPastMaxAge(state, level, pos, random);
            } else {
                level.setBlockAndUpdate(pos, this.getStateForAge(age + 1));
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean canGrowPastMaxAge() {
        return false;
    }

    public void growPastMaxAge(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected static float getGrowthSpeed(BlockState state, BlockGetter level, BlockPos pos) {
        boolean matchesNorthSouthRow;
        float speed = 1.0f;
        BlockPos posBelow = pos.below();
        for (int posX = -1; posX <= 1; ++posX) {
            for (int posZ = -1; posZ <= 1; ++posZ) {
                float speedBonus = 0.0f;
                BlockState stateBelow = level.getBlockState(posBelow.offset(posX, 0, posZ));
                TriState soilDecision = stateBelow.canSustainPlant(level, posBelow.offset(posX, 0, posZ), Direction.UP, state);
                if (soilDecision.isDefault()) {
                    speedBonus = 1.0f;
                    if (stateBelow.isFertile(level, pos.offset(posX, 0, posZ))) {
                        speedBonus = 3.0f;
                    }
                }
                if (posX != 0 || posZ != 0) {
                    speedBonus /= 4.0f;
                }
                speed += speedBonus;
            }
        }
        BlockPos posNorth = pos.north();
        BlockPos posSouth = pos.south();
        BlockPos posWest = pos.west();
        BlockPos posEast = pos.east();
        Block block = state.getBlock();
        boolean matchesEastWestRow = level.getBlockState(posWest).is(block) || level.getBlockState(posEast).is(block);
        boolean bl = matchesNorthSouthRow = level.getBlockState(posNorth).is(block) || level.getBlockState(posSouth).is(block);
        if (matchesEastWestRow && matchesNorthSouthRow) {
            speed /= 2.0f;
        } else {
            boolean matchesDiagonalRows;
            boolean bl2 = matchesDiagonalRows = level.getBlockState(posWest.north()).is(block) || level.getBlockState(posEast.north()).is(block) || level.getBlockState(posEast.south()).is(block) || level.getBlockState(posWest.south()).is(block);
            if (matchesDiagonalRows) {
                speed /= 2.0f;
            }
        }
        return speed;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soilDecision = level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return BuddingBushBlock.hasSufficientLight(level, pos) && super.canSurvive(state, level, pos);
    }

    public static boolean hasSufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && EventHooks.canEntityGrief((Level)level, (Entity)entity)) {
            level.destroyBlock(pos, true, entity);
        }
        super.entityInside(state, level, pos, entity);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.TOMATO_SEEDS.get();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

