/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.chained_cogwheel;

import com.petrolpark.petrolsparts.content.chained_cogwheel.ChainedCogwheelBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChainedCogwheelBlock
extends AbstractSimpleShaftBlock
implements ICogWheel {
    protected final boolean large;

    protected ChainedCogwheelBlock(BlockBehaviour.Properties properties, boolean large) {
        super(properties);
        this.large = large;
    }

    public static ChainedCogwheelBlock large(BlockBehaviour.Properties properties) {
        return new ChainedCogwheelBlock(properties, true);
    }

    public static ChainedCogwheelBlock small(BlockBehaviour.Properties properties) {
        return new ChainedCogwheelBlock(properties, false);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        BlockEntity blockEntity = this.getBlockEntity(level, pos);
        if (blockEntity instanceof ChainedCogwheelBlockEntity) {
            ChainedCogwheelBlockEntity cbe = (ChainedCogwheelBlockEntity)blockEntity;
            if (cbe.copiedState != null) {
                return cbe.copiedState.getShape(level, pos, context);
            }
        }
        return Shapes.block();
    }

    public static void tryPlace(Player player, Level level, BlockPos pos1, BlockPos pos2) {
    }

    public ItemStack getCloneItemStack(@Nonnull BlockState state, @Nonnull HitResult target, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Player player) {
        KineticBlockEntity kbe = (KineticBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (kbe instanceof ChainedCogwheelBlockEntity) {
            ChainedCogwheelBlockEntity cbe = (ChainedCogwheelBlockEntity)kbe;
            if (cbe.copiedState != null) {
                return cbe.copiedState.getCloneItemStack(target, level, pos, player);
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        KineticBlockEntity kbe = (KineticBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (kbe instanceof ChainedCogwheelBlockEntity) {
            Block block;
            ChainedCogwheelBlockEntity cbe = (ChainedCogwheelBlockEntity)kbe;
            if (cbe.copiedState != null && (block = cbe.copiedState.getBlock()) instanceof IRotate) {
                IRotate rotate = (IRotate)block;
                return rotate.hasShaftTowards(world, pos, cbe.copiedState, face);
            }
        }
        return false;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return null;
    }

    public boolean isLargeCog() {
        return this.large;
    }
}

