/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.compat.create.core.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.PetrolsPartsShapes;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoaxialGearBlock
extends CogWheelBlock {
    public static final BooleanProperty HAS_SHAFT = BooleanProperty.create((String)"has_shaft");

    public static boolean isCoaxialGear(BlockState state) {
        return state.getBlock() instanceof CoaxialGearBlock;
    }

    public static boolean isCoaxialGear(Block block) {
        return block instanceof CoaxialGearBlock;
    }

    public CoaxialGearBlock(BlockBehaviour.Properties properties, boolean large) {
        super(large, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    public static CoaxialGearBlock large(BlockBehaviour.Properties properties) {
        return new CoaxialGearBlock(properties, true);
    }

    public static CoaxialGearBlock small(BlockBehaviour.Properties properties) {
        return new CoaxialGearBlock(properties, false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_SHAFT});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.getValue((Property)HAS_SHAFT) != false ? AllShapes.SMALL_GEAR : PetrolsPartsShapes.COAXIAL_GEAR).get((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS));
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) {
            CoaxialGearBlock.updatePropagationOfLongShaft(oldState, (LevelReader)worldIn, pos);
        }
        super.onPlace(state, worldIn, pos, oldState, isMoving);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)worldIn, (BlockPos)pos, (LivingEntity)placer);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) {
            if (this.tryRemoveBracket(context)) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryRemoveLongShaft(state, context.getLevel(), context.getClickedPos(), false)) {
                Player player = context.getPlayer();
                if (player != null && player.isCreative()) {
                    player.getInventory().placeItemBackInInventory(PetrolsPartsBlocks.COAXIAL_GEAR.asStack());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.onWrenched(state, context);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getAxis() == state.getValue((Property)AXIS)) {
            CoaxialGearBlock.updatePropagationOfLongShaft(state, (LevelReader)level, currentPos);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public static void updatePropagationOfLongShaft(BlockState state, LevelReader level, BlockPos pos) {
        if (CoaxialGearBlock.isCoaxialGear(state) && ((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue() && !level.isClientSide()) {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                BlockPos longShaftPos = pos.relative(Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
                BlockState longShaftState = level.getBlockState(pos.relative(Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)axis)));
                if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.getValue((Property)AXIS) != axis || (Boolean)longShaftState.getValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) != (axisDirection != Direction.AxisDirection.POSITIVE)) continue;
                level.getBlockEntity(longShaftPos, (BlockEntityType)PetrolsPartsBlockEntityTypes.LONG_SHAFT.get()).ifPresent(be -> {
                    be.updateSpeed = true;
                });
                return;
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState && newState.isAir() && !isMoving && this.tryRemoveLongShaft(state, world, pos, true)) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)AllBlocks.SHAFT.asStack());
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public static boolean tryMakeLongShaft(BlockState state, Block coaxialGearBlock, Level level, BlockPos pos, Player player, Direction preferredDirection) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (preferredDirection.getAxis() != axis) {
            return false;
        }
        for (Direction direction : new Direction[]{preferredDirection, preferredDirection.getOpposite()}) {
            BlockPos shaftPos = pos.relative(direction);
            BlockState shaftState = level.getBlockState(shaftPos);
            if (!ShaftBlock.isShaft((BlockState)shaftState) || shaftState.getValue((Property)AXIS) != axis) continue;
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(shaftPos, (BlockState)((BlockState)PetrolsPartsBlocks.LONG_SHAFT.getDefaultState().setValue((Property)AXIS, (Comparable)axis)).setValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.getAxisDirection() != Direction.AxisDirection.POSITIVE)));
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)coaxialGearBlock.defaultBlockState().setValue((Property)AXIS, (Comparable)axis)).setValue((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(true)));
                AbstractRememberPlacerBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    protected boolean tryRemoveLongShaft(BlockState state, Level level, BlockPos pos, boolean removing) {
        Direction.Axis thisAxis = (Direction.Axis)state.getValue((Property)AXIS);
        for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
            BlockPos longShaftPos = pos.relative(Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)thisAxis));
            BlockState longShaftState = level.getBlockState(longShaftPos);
            if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.getValue((Property)AXIS) != thisAxis || (Boolean)longShaftState.getValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) == (axisDirection == Direction.AxisDirection.POSITIVE)) continue;
            if (!level.isClientSide()) {
                if (!removing) {
                    level.setBlockAndUpdate(pos, (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)AXIS, (Comparable)thisAxis));
                }
                level.setBlockAndUpdate(longShaftPos, (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)AXIS, (Comparable)thisAxis));
            }
            return true;
        }
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (AllBlocks.SHAFT.isIn(stack) && !((Boolean)state.getValue((Property)HAS_SHAFT)).booleanValue()) {
            if (CoaxialGearBlock.tryMakeLongShaft(state, state.getBlock(), world, pos, player, Direction.getFacingAxis((Entity)player, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS))))) {
                if (!player.isCreative() && !world.isClientSide()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            player.displayClientMessage((Component)Component.translatable((String)"petrolsparts.tooltip.coaxial_gear.shaft_too_short").withStyle(ChatFormatting.RED), true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.COAXIAL_GEAR.get();
    }
}

