/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.corner_shaft;

import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.content.corner_shaft.AbstractCornerShaftBlock;
import com.petrolpark.petrolsparts.content.corner_shaft.CornerShaftBlockEntity;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CornerShaftBlock
extends AbstractCornerShaftBlock
implements ProperWaterloggedBlock,
EncasableBlock {
    public CornerShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withWater(super.getStateForPlacement(context), context);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemInteractionResult result = this.tryEncase(state, level, pos, stack, player, hand, hitResult);
        if (result.consumesAction()) {
            return result;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction xDirection = null;
        Direction yDirection = null;
        Direction zDirection = null;
        block5: for (Direction direction : CornerShaftBlock.getDirectionsConnectedByState(state)) {
            switch (direction.getAxis()) {
                case X: {
                    xDirection = direction;
                    continue block5;
                }
                case Y: {
                    yDirection = direction;
                    continue block5;
                }
                case Z: {
                    zDirection = direction;
                }
            }
        }
        return new AllShapes.Builder(Block.box((double)(xDirection == Direction.WEST ? 0.0 : 5.0), (double)(yDirection == Direction.DOWN ? 0.0 : 5.0), (double)(zDirection == Direction.NORTH ? 0.0 : 5.0), (double)(xDirection == Direction.EAST ? 16.0 : 11.0), (double)(yDirection == Direction.UP ? 16.0 : 11.0), (double)(zDirection == Direction.SOUTH ? 16.0 : 11.0))).build();
    }

    protected FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Override
    public Class<CornerShaftBlockEntity> getBlockEntityClass() {
        return CornerShaftBlockEntity.class;
    }

    public BlockEntityType<? extends CornerShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.CORNER_SHAFT.get();
    }
}

