/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.client.data.outline.ElevatedPyramidSlabOutlineRenderer;
import xfacthd.framedblocks.client.data.outline.PyramidSlabOutlineRenderer;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public sealed class PyramidOutlineRenderer
implements OutlineRenderer
permits PyramidSlabOutlineRenderer, ElevatedPyramidSlabOutlineRenderer {
    private static final Quaternionf[] XN_DIR = PyramidOutlineRenderer.makeQuaternionArray();

    @Override
    public final void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        this.drawTopPart(state, pstack, builder);
    }

    protected void drawTopPart(BlockState state, PoseStack pstack, VertexConsumer builder) {
        switch ((PillarConnection)((Object)state.getValue(PropertyHolder.PILLAR_CONNECTION))) {
            case PILLAR: {
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.25f, 0.5f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 0.75f, 0.5f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 0.25f, 0.5f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 1.0f, 0.75f, 0.5f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 0.5f, 0.25f, 0.25f, 1.0f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 0.75f, 0.5f, 0.25f, 0.75f, 1.0f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 0.5f, 0.75f, 0.25f, 1.0f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.75f, 0.5f, 0.75f, 0.75f, 1.0f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 0.5f, 0.25f, 0.25f, 0.5f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.75f, 0.5f, 0.25f, 0.75f, 0.5f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 0.5f, 0.25f, 0.75f, 0.5f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 0.5f, 0.75f, 0.75f, 0.5f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 1.0f, 0.25f, 0.25f, 1.0f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.75f, 1.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 1.0f, 0.25f, 0.75f, 1.0f, 0.25f);
                OutlineRenderer.drawLine(builder, pstack, 0.25f, 1.0f, 0.75f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case POST: {
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.375f, 0.75f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 0.625f, 0.75f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 0.375f, 0.75f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 1.0f, 0.625f, 0.75f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 0.75f, 0.375f, 0.375f, 1.0f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 0.625f, 0.75f, 0.375f, 0.625f, 1.0f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 0.75f, 0.625f, 0.375f, 1.0f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.625f, 0.75f, 0.625f, 0.625f, 1.0f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 0.75f, 0.375f, 0.375f, 0.75f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.625f, 0.75f, 0.375f, 0.625f, 0.75f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 0.75f, 0.375f, 0.625f, 0.75f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 0.75f, 0.625f, 0.625f, 0.75f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 1.0f, 0.375f, 0.375f, 1.0f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.625f, 1.0f, 0.375f, 0.625f, 1.0f, 0.625f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 1.0f, 0.375f, 0.625f, 1.0f, 0.375f);
                OutlineRenderer.drawLine(builder, pstack, 0.375f, 1.0f, 0.625f, 0.625f, 1.0f, 0.625f);
                break;
            }
            case NONE: {
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 0.5f, 1.0f, 0.5f);
                OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f, 0.5f);
                OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, 0.5f);
            }
        }
    }

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (dir == Direction.DOWN) {
            poseStack.mulPose(Quaternions.ZP_180);
        } else if (dir != Direction.UP) {
            poseStack.mulPose(Quaternions.ZP_90);
            poseStack.mulPose(XN_DIR[dir.get2DDataValue()]);
        }
    }

    private static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.get2DDataValue()] = Axis.XN.rotationDegrees(dir.toYRot() - 90.0f);
        }
        return array;
    }
}

