/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.torch;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.MultiQuadModifier;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChainType;

public class FramedLanternGeometry
extends Geometry {
    public static final ModelResourceLocation STANDING_CHAIN_LOCATION = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("block/framed_lantern_chain_standing"));
    public static final ModelResourceLocation HANGING_CHAIN_LOCATION = ModelResourceLocation.standalone((ResourceLocation)Utils.rl("block/framed_lantern_chain_hanging"));
    private static final ChunkRenderTypeSet SOLID_CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.solid(), RenderType.cutout()});
    private static final Vector3f ROT_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);
    private final BlockState state;
    private final boolean hanging;
    private final ChainType chain;
    private final boolean soul;
    private final BakedModel baseModel;
    private final BakedModel chainModel;

    private FramedLanternGeometry(GeometryFactory.Context ctx, boolean soul) {
        this.state = ctx.state();
        this.hanging = (Boolean)ctx.state().getValue((Property)BlockStateProperties.HANGING);
        this.chain = (ChainType)((Object)ctx.state().getValue(PropertyHolder.CHAIN_TYPE));
        this.soul = soul;
        this.baseModel = ctx.baseModel();
        this.chainModel = ctx.modelLookup().get(this.hanging ? HANGING_CHAIN_LOCATION : STANDING_CHAIN_LOCATION);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            boolean up = quadDir == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).applyIf(Modifiers.setPosition(0.9375f), this.hanging && !up).applyIf(Modifiers.setPosition(this.hanging ? 0.5f : 0.4375f), up).export(this.hanging || up ? quadMap.get(null) : quadMap.get(Direction.DOWN));
            if (up) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(this.hanging ? 0.625f : 0.5625f)).export(quadMap.get(null));
            }
        } else {
            List<QuadModifier> sideMods = List.of(QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.375f, 0.4375f)), QuadModifier.of(quad).apply(Modifiers.cutSide(0.625f, 0.0f, 0.6875f, 0.4375f)), QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.0f, 0.625f, 0.0625f)), QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.375f, 0.625f, 0.4375f)));
            for (QuadModifier mod : sideMods) {
                mod.applyIf(Modifiers.offset(Direction.UP, 0.0625f), this.hanging).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
            }
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, this.soul ? 0.4375f : 0.5f, 0.625f, 0.5625f)).applyIf(Modifiers.offset(Direction.UP, 0.0625f), this.hanging).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            if (this.chain == ChainType.CAMO) {
                this.createCamoChain(quadMap, quad, quadDir);
            }
        }
    }

    private void createCamoChain(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        Direction.Axis quadPerpAxis = Utils.isX(quadDir) ? Direction.Axis.Z : Direction.Axis.X;
        Direction dirNeg = Direction.fromAxisAndDirection((Direction.Axis)quadPerpAxis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        Direction dirPos = Direction.fromAxisAndDirection((Direction.Axis)quadPerpAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ArrayList<MultiQuadModifier> modifiers = new ArrayList<MultiQuadModifier>();
        MultiQuadModifier baseEdgeMod = new MultiQuadModifier(QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(dirNeg, 0.625f)).apply(Modifiers.cutSideLeftRight(dirPos, 0.4375f)).apply(Modifiers.offset(dirPos, 0.03125f)), QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(dirNeg, 0.4375f)).apply(Modifiers.cutSideLeftRight(dirPos, 0.625f)).apply(Modifiers.offset(dirNeg, 0.03125f)));
        if (Utils.isX(quadDir) || !this.hanging) {
            modifiers.add(baseEdgeMod.derive().apply(Modifiers.cutSideUpDown(true, this.hanging ? 0.375f : 0.4375f)).apply(Modifiers.cutSideUpDown(false, this.hanging ? 0.75f : 0.6875f)));
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.hanging && i == 0) continue;
            float height = i == 0 ? 2.0f : (float)(this.hanging ? 5 : 6);
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(0.53125f)).apply(Modifiers.cutSideUpDown(true, height / 16.0f)).apply(Modifiers.cutSideUpDown(false, (16.0f - height + 1.0f) / 16.0f)).apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotate(Direction.Axis.Y, ROT_ORIGIN, 45.0f, false)).export(quadMap.get(null));
        }
        if (this.hanging) {
            if (Utils.isX(quadDir)) {
                modifiers.add(baseEdgeMod.derive().apply(Modifiers.cutSideUpDown(true, 0.125f)));
            } else if (Utils.isZ(quadDir)) {
                modifiers.add(baseEdgeMod.derive().apply(Modifiers.cutSideUpDown(true, 0.3125f)).apply(Modifiers.cutSideUpDown(false, 0.9375f)));
            }
        }
        for (MultiQuadModifier mod : modifiers) {
            mod.apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotate(Direction.Axis.Y, ROT_ORIGIN, 45.0f, false)).export(quadMap.get(null));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.chain == ChainType.METAL ? SOLID_CUTOUT : ModelUtils.SOLID;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (renderType == RenderType.solid()) {
            quadMap.get(null).addAll(this.baseModel.getQuads(this.state, null, rand, ModelData.EMPTY, renderType));
        } else if (renderType == RenderType.cutout() && this.chain == ChainType.METAL) {
            quadMap.get(null).addAll(this.chainModel.getQuads(this.state, null, rand, ModelData.EMPTY, renderType));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    public static FramedLanternGeometry normal(GeometryFactory.Context ctx) {
        return new FramedLanternGeometry(ctx, false);
    }

    public static FramedLanternGeometry soul(GeometryFactory.Context ctx) {
        return new FramedLanternGeometry(ctx, true);
    }
}

