/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.RegisterOutlineRenderersEvent;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.config.DevToolsConfig;

public final class BlockOutlineRenderer {
    private static final Map<IBlockType, OutlineRenderer> OUTLINE_RENDERERS = new IdentityHashMap<IBlockType, OutlineRenderer>();
    private static final Set<IBlockType> ERRORED_TYPES = new HashSet<IBlockType>();

    public static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        if (!ClientConfig.VIEW.useFancySelectionBoxes() && !DevToolsConfig.VIEW.isOcclusionShapeDebugRenderingEnabled()) {
            return;
        }
        BlockHitResult result = event.getTarget();
        BlockState state = Minecraft.getInstance().level.getBlockState(result.getBlockPos());
        Block block = state.getBlock();
        if (!(block instanceof IFramedBlock)) {
            return;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        if (DevToolsConfig.VIEW.isOcclusionShapeDebugRenderingEnabled()) {
            VertexConsumer builder = event.getMultiBufferSource().getBuffer(RenderType.lines());
            VoxelShape shape = state.getOcclusionShape((BlockGetter)Minecraft.getInstance().level, result.getBlockPos());
            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)result.getBlockPos()).subtract(event.getCamera().getPosition());
            LevelRenderer.renderShape((PoseStack)event.getPoseStack(), (VertexConsumer)builder, (VoxelShape)shape, (double)offset.x, (double)offset.y, (double)offset.z, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            event.setCanceled(true);
            return;
        }
        IBlockType type = block2.getBlockType();
        if (type.hasSpecialHitbox()) {
            OutlineRenderer renderer = OUTLINE_RENDERERS.get(type);
            if (renderer == null) {
                if (ERRORED_TYPES.add(type)) {
                    FramedBlocks.LOGGER.error("IBlockType '{}' requests custom outline rendering but no OutlineRender was registered!", (Object)type.getName());
                }
                return;
            }
            PoseStack mstack = event.getPoseStack();
            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)result.getBlockPos()).subtract(event.getCamera().getPosition());
            VertexConsumer builder = event.getMultiBufferSource().getBuffer(RenderType.lines());
            mstack.pushPose();
            mstack.translate(offset.x, offset.y, offset.z);
            mstack.translate(0.5, 0.5, 0.5);
            renderer.rotateMatrix(mstack, state);
            mstack.translate(-0.5, -0.5, -0.5);
            renderer.draw(state, (Level)Minecraft.getInstance().level, result.getBlockPos(), mstack, builder);
            mstack.popPose();
            event.setCanceled(true);
        }
    }

    public static void init() {
        ModLoader.postEvent((Event)new RegisterOutlineRenderersEvent((type, renderer) -> {
            Preconditions.checkArgument((boolean)type.hasSpecialHitbox(), (String)"IBlockType %s doesn't return true from IBlockType#hasSpecialHitbox()", (Object)type);
            OUTLINE_RENDERERS.put((IBlockType)type, (OutlineRenderer)renderer);
        }));
    }

    public static boolean hasOutlineRenderer(IBlockType type) {
        return OUTLINE_RENDERERS.containsKey(type);
    }

    private BlockOutlineRenderer() {
    }
}

