/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerTubeOrientation;

public class FramedCornerTubeBlock
extends FramedBlock {
    public FramedCornerTubeBlock() {
        super(BlockType.FRAMED_CORNER_TUBE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.THICK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.CORNER_TYPE_ORIENTATION, FramedProperties.SOLID, PropertyHolder.THICK, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            Direction secDir;
            Direction primDir = modCtx.getClickedFace();
            Vec3 hitVec = modCtx.getClickLocation();
            if (Utils.isY(primDir)) {
                forwardDir = modCtx.getHorizontalDirection();
                double forward = Utils.fractionInDir(hitVec, forwardDir) - 0.5;
                double sideways = Utils.fractionInDir(hitVec, forwardDir.getClockWise()) - 0.5;
                secDir = Math.max(Math.abs(forward), Math.abs(sideways)) == Math.abs(forward) ? (forward < 0.0 ? forwardDir.getOpposite() : forwardDir) : (sideways < 0.0 ? forwardDir.getCounterClockWise() : forwardDir.getClockWise());
            } else {
                forwardDir = primDir.getOpposite();
                boolean right = Utils.fractionInDir(hitVec, forwardDir.getClockWise()) > 0.5;
                secDir = right ? forwardDir.getClockWise() : forwardDir.getCounterClockWise();
            }
            CornerTubeOrientation orientation = CornerTubeOrientation.of(primDir, secDir);
            return (BlockState)state.setValue(PropertyHolder.CORNER_TYPE_ORIENTATION, (Comparable)((Object)orientation));
        })).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().is((Item)Utils.FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                state = (BlockState)state.setValue((Property)PropertyHolder.THICK, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)PropertyHolder.THICK) == false));
                level.setBlock(pos, state, 3);
            }
            return true;
        }
        return false;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return ((CornerTubeOrientation)((Object)state.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION))).isVertical();
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        CornerTubeOrientation orientation = (CornerTubeOrientation)((Object)state.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        return (BlockState)state.setValue(PropertyHolder.CORNER_TYPE_ORIENTATION, (Comparable)((Object)orientation.rotate(rotation)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CornerTubeOrientation orientation = (CornerTubeOrientation)((Object)state.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        return (BlockState)state.setValue(PropertyHolder.CORNER_TYPE_ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.CORNER_TYPE_ORIENTATION, (Comparable)((Object)CornerTubeOrientation.UP_NORTH));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

