/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedMiniCubeBlock
extends FramedBlock {
    public FramedMiniCubeBlock() {
        super(BlockType.FRAMED_MINI_CUBE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.ROTATION_16, FramedProperties.TOP, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(modCtx.getRotation() + 180.0f)))))).withTop()).withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rotation) {
        int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        rot = rotation == Rotation.CLOCKWISE_90 ? (rot + 1) % 16 : (rot + 15) % 16;
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation.rotate(rot, 16)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(mirror.mirror(rot, 16)));
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static final class MiniCubeStateMerger
    implements StateMerger {
        public static final MiniCubeStateMerger INSTANCE = new MiniCubeStateMerger();
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_WATERLOGGED);

        private MiniCubeStateMerger() {
        }

        @Override
        public BlockState apply(BlockState state) {
            int rot = (Integer)(state = this.ignoringMerger.apply(state)).getValue((Property)BlockStateProperties.ROTATION_16);
            if (rot > 3) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot % 4));
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(BlockStateProperties.ROTATION_16));
        }
    }
}

