/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.capability;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.energy.EnergyStorage;

public class EntityAwareEnergyStorage
extends EnergyStorage {
    private final Runnable changeNotifier;

    public EntityAwareEnergyStorage(int capacity, int maxReceive, int maxExtract, Runnable changeNotifier) {
        super(capacity, maxReceive, maxExtract);
        this.changeNotifier = changeNotifier;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        this.onContentsChanged(received, simulate);
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        this.onContentsChanged(extracted, simulate);
        return extracted;
    }

    public void extractEnergyInternal(int maxExtract) {
        this.energy -= maxExtract;
        this.onContentsChanged(maxExtract, false);
    }

    private void onContentsChanged(int diff, boolean simulate) {
        if (!simulate && diff > 0) {
            this.changeNotifier.run();
        }
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("energy", this.energy);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag tag) {
        int n;
        if (tag instanceof CompoundTag) {
            CompoundTag cmpTag = (CompoundTag)tag;
            n = cmpTag.getInt("energy");
        } else {
            n = 0;
        }
        this.energy = n;
        this.energy = Math.min(this.energy, this.capacity);
    }
}

