/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.emi.FramedEmiPlugin;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawEmiRecipe
extends BasicEmiRecipe {
    private static final int WIDTH = 120;
    private static final int HEIGHT = 43;
    private static final int WARNING_X = 38;
    private static final int WARNING_Y = 3;
    private static final int WARNING_SIZE = 16;
    private static final float WARNING_SCALE = 0.75f;
    private static final int WARNING_DRAW_SIZE = 12;
    private static final EmiTexture TEXTURE_WARNING = new EmiTexture(FramingSawScreen.WARNING_ICON, 8, 8, 12, 12, 16, 16, 32, 32);
    private final RecipeHolder<FramingSawRecipe> recipe;
    private final boolean showOnRecipeRequest;
    private final boolean inputWithAdditives;

    private FramingSawEmiRecipe(RecipeHolder<FramingSawRecipe> recipe, ResourceLocation id, EmiStack input, List<EmiIngredient> additives, EmiStack output) {
        super((EmiRecipeCategory)FramedEmiPlugin.SAW_CATEGORY.get(), id, 120, 43);
        this.recipe = recipe;
        this.showOnRecipeRequest = input.getItemStack().is(((Block)FBContent.BLOCK_FRAMED_CUBE.value()).asItem());
        this.inputWithAdditives = FramingSawRecipeCache.get(true).containsAdditive(input.getItemStack().getItem());
        this.inputs.add(input);
        this.inputs.addAll(additives);
        this.outputs.add(output);
    }

    public List<EmiStack> getOutputs() {
        return this.showOnRecipeRequest ? super.getOutputs() : List.of();
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 19, 1);
        for (int i = 0; i < 3; ++i) {
            int x = 1 + i * 18;
            int idx = i + 1;
            if (idx < this.inputs.size()) {
                widgets.addSlot((EmiIngredient)this.inputs.get(idx), x, 24);
                continue;
            }
            widgets.addTexture(EmiTexture.SLOT, x, 24);
        }
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 93, 9).large(true).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 12);
        if (this.inputWithAdditives) {
            widgets.addTexture(TEXTURE_WARNING, 38, 3);
            widgets.add((Widget)widgets.addTooltipText(List.of(FramingSawScreen.TOOLTIP_LOOSE_ADDITIVE), 38, 3, 12, 12));
        }
    }

    public IBlockType getResultType() {
        return ((FramingSawRecipe)this.recipe.value()).getResultType();
    }

    public RecipeHolder<FramingSawRecipe> getBackingRecipe() {
        return this.recipe;
    }

    public ItemStack getOutputInternal() {
        return ((EmiStack)this.outputs.getFirst()).getItemStack();
    }

    public static FramingSawEmiRecipe make(RecipeHolder<FramingSawRecipe> recipe, EmiStack input, List<EmiIngredient> additives, EmiStack output) {
        boolean showOnRecipeRequest = input.getItemStack().is(((Block)FBContent.BLOCK_FRAMED_CUBE.value()).asItem());
        ResourceLocation id = showOnRecipeRequest ? recipe.id() : null;
        return new FramingSawEmiRecipe(recipe, id, input, additives, output);
    }
}

