/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.jei.ClickableStack;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.menu.PoweredFramingSawMenu;

public final class PoweredFramingSawGuiContainerHandler
implements IGuiContainerHandler<PoweredFramingSawScreen> {
    private final IIngredientManager ingredientManager;

    public PoweredFramingSawGuiContainerHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(PoweredFramingSawScreen screen, double mouseX, double mouseY) {
        int minX = 115;
        int minY = 46;
        int maxX = minX + 22;
        int maxY = minY + 16;
        if (mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            return List.of(new ClickableArea(new Rect2i(minX, minY, 22, 16), this.ingredientManager));
        }
        return List.of();
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(PoweredFramingSawScreen screen, double mouseX, double mouseY) {
        RecipeHolder<FramingSawRecipe> recipe = ((PoweredFramingSawMenu)screen.getMenu()).getSelectedRecipe();
        if (screen.isMouseOverRecipeSlot(mouseX, mouseY) && recipe != null) {
            return this.ingredientManager.createTypedIngredient((Object)((FramingSawRecipe)recipe.value()).getResult()).map(stack -> new ClickableStack((ITypedIngredient<ItemStack>)stack, screen.getTargetStackArea()));
        }
        return Optional.empty();
    }

    private record ClickableArea(Rect2i area, IIngredientManager ingredients) implements IGuiClickableArea
    {
        public Rect2i getArea() {
            return this.area;
        }

        public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
            Optional optIng = this.ingredients.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FBContent.BLOCK_POWERED_FRAMING_SAW.value()));
            optIng.ifPresent(ing -> recipesGui.show(focusFactory.createFocus(RecipeIngredientRole.CATALYST, ing)));
        }
    }
}

