/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.rei;

import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class PoweredFramingSawDraggableStackVisitor
implements DraggableStackVisitor<PoweredFramingSawScreen> {
    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof PoweredFramingSawScreen;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<PoweredFramingSawScreen> context, DraggableStack draggableStack) {
        Object object = draggableStack.getStack().getValue();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (FramingSawRecipeCache.get(true).getMaterialValue(stack.getItem()) > 0) {
                PoweredFramingSawScreen screen = (PoweredFramingSawScreen)context.getScreen();
                return Stream.of(DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(screen.getTargetStackX() - 1, screen.getTargetStackY() - 1, 18, 18)));
            }
        }
        return Stream.empty();
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<PoweredFramingSawScreen> context, DraggableStack draggableStack) {
        PoweredFramingSawScreen screen = (PoweredFramingSawScreen)context.getScreen();
        int sx = screen.getTargetStackX();
        int sy = screen.getTargetStackY();
        Point pos = context.getCurrentPosition();
        if (pos == null || pos.x < sx || pos.x >= sx + 18 || pos.y < sy || pos.y >= sy + 18) {
            return DraggedAcceptorResult.PASS;
        }
        Object object = draggableStack.getStack().getValue();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (FramingSawRecipeCache.get(true).getMaterialValue(stack.getItem()) > 0) {
                ((PoweredFramingSawScreen)context.getScreen()).selectRecipe(stack);
                return DraggedAcceptorResult.ACCEPTED;
            }
        }
        return DraggedAcceptorResult.PASS;
    }
}

