/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeFluidType;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class BannerPatternPrintingBehavior
implements PrintingBehaviour {
    private final SmartFluidTankBehaviour tank;
    private final Holder<BannerPattern> pattern;

    public BannerPatternPrintingBehavior(SmartFluidTankBehaviour tank, Holder<BannerPattern> pattern) {
        this.tank = tank;
        this.pattern = pattern;
    }

    public static Optional<DataResult<PrintingBehaviour>> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        if (!stack.is(ItemTags.BANNERS)) {
            return Optional.empty();
        }
        BannerPatternLayers layers = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
        if (layers.layers().isEmpty()) {
            return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.banner_pattern.no_pattern")));
        }
        if (layers.layers().size() > 1) {
            return Optional.of(DataResult.error(() -> CEICommon.asLocalization("gui.printer.banner_pattern.multiple_pattern")));
        }
        return Optional.of(DataResult.success((Object)new BannerPatternPrintingBehavior(tank, (Holder<BannerPattern>)((BannerPatternLayers.Layer)layers.layers().getFirst()).pattern())));
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        if (stack.is(ItemTags.BANNERS)) {
            BannerPatternLayers layers = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            if (layers.layers().isEmpty()) {
                return 1;
            }
            if (((BannerPattern)((BannerPatternLayers.Layer)layers.layers().getLast()).pattern().value()).assetId().equals((Object)((BannerPattern)this.pattern.value()).assetId())) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        Integer cost = (Integer)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_BANNER_PATTERN_INGREDIENT);
        return cost == null ? 0 : cost;
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        BannerPatternLayers layers = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
        ArrayList<BannerPatternLayers.Layer> l = new ArrayList<BannerPatternLayers.Layer>();
        l.addAll(layers.layers());
        l.add(new BannerPatternLayers.Layer(this.pattern, ((DyeFluidType)fluidStack.getFluidType()).getColor()));
        ItemStack result = stack.copy();
        result.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(l));
        return result;
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        level.levelEvent(1043, pos.below(), 0);
    }

    @Override
    public boolean isSafeNBT() {
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CEILang.translate("gui.goggles.printing.banner_pattern", new Object[0]).forGoggles(tooltip);
        Integer amount = (Integer)this.tank.getPrimaryHandler().getFluid().getFluidHolder().getData(CEIDataMaps.PRINTING_BANNER_PATTERN_INGREDIENT);
        if (amount != null) {
            MutableComponent p = Component.literal((String)"\u2192 ").append((Component)Component.translatable((String)(((BannerPattern)this.pattern.value()).translationKey() + "." + ((DyeFluidType)this.tank.getPrimaryHandler().getFluid().getFluidType()).getColor().getName()))).withStyle(ChatFormatting.GOLD);
            CEILang.builder().add(p).forGoggles(tooltip, 1);
            CEILang.translate("gui.goggles.printing.cost", CEILang.number(amount.intValue()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(amount <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1);
        } else if (!this.tank.getPrimaryHandler().getFluid().isEmpty()) {
            CEILang.translate("gui.goggles.printing.incorrect_liquid", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        }
        return true;
    }
}

