/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.printing;

import com.mojang.serialization.MapCodec;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.util.Pairs;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.util.CEILang;

public enum CustomNamePrintingRecipeJEI implements PrintingRecipeJEI
{
    INSTANCE;

    public static final PrintingRecipeJEI.Type TYPE;

    @Override
    public void setBase(IRecipeSlotBuilder slot) {
        slot.addItemLike((ItemLike)Items.NAME_TAG);
        slot.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)CEILang.translate("recipe.printing.custom_name.base", new Object[0]).style(ChatFormatting.GRAY).component()));
    }

    @Override
    public void setTemplate(IRecipeSlotBuilder slot) {
        ItemStack stack = new ItemStack((ItemLike)Items.NAME_TAG);
        MutableComponent name = CEILang.translate("recipe.printing.custom_name.template", new Object[0]).component();
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        slot.addItemStack(stack);
    }

    @Override
    public void setFluid(IRecipeSlotBuilder slot) {
        CEIDataMaps.getSourceFluidEntries(CEIDataMaps.PRINTING_CUSTOM_NAME_INGREDIENT).forEach(Pairs.accept((arg_0, arg_1) -> ((IRecipeSlotBuilder)slot).addFluidStack(arg_0, arg_1)));
    }

    @Override
    public void setOutput(IRecipeSlotBuilder slot) {
        slot.addItemLike((ItemLike)Items.NAME_TAG);
    }

    @Override
    public PrintingRecipeJEI.Type getType() {
        return TYPE;
    }

    @Override
    public void onDisplayedIngredientsUpdate(IRecipeSlotDrawable baseSlot, IRecipeSlotDrawable templateSlot, IRecipeSlotDrawable fluidSlot, IRecipeSlotDrawable outputSlot, IFocusGroup focuses) {
        MutableComponent name = CEILang.translate("recipe.printing.custom_name.template", new Object[0]).component();
        FluidStack fluidStack = fluidSlot.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).orElse(FluidStack.EMPTY);
        Style style = (Style)fluidStack.getFluidHolder().getData(CEIDataMaps.PRINTING_CUSTOM_NAME_STYLE);
        if (style != null) {
            name.withStyle(style);
        }
        ItemStack stack = new ItemStack((ItemLike)Items.NAME_TAG);
        if (((Boolean)CEIConfig.fluids().printingCustomNameAsItemName.get()).booleanValue()) {
            stack.set(DataComponents.ITEM_NAME, (Object)name);
        } else {
            stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        }
        outputSlot.createDisplayOverrides().addItemStack(stack);
    }

    static {
        TYPE = PrintingRecipeJEI.register(CEICommon.asResource("custom_name"), (MapCodec<? extends PrintingRecipeJEI>)MapCodec.unit((Object)INSTANCE));
    }
}

