/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import java.util.Arrays;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class Noise2D
implements DensityFunction,
FunctionWithCache {
    public static final MapCodec<Noise2D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.HOLDER_HELPER_CODEC).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.BOOL.optionalFieldOf("global", (Object)false).forGetter(d -> d.global), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise2D::new));
    public static final KeyDispatchDataCodec<Noise2D> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final Either<Double, DensityFunction> xzScale;
    public final boolean global;
    public final long seed;
    private final Cache cache;

    private Noise2D(Either<Double, DensityFunction> xzScale, boolean global, long seed, Cache cache) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = cache;
        this.global = global;
    }

    public Noise2D(Either<Double, DensityFunction> xzScale, boolean global, long seed) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = null;
        this.global = global;
    }

    public Noise2D create(long seed, int minX, int maxX, int minZ, int maxZ) {
        return new Noise2D(this.xzScale, this.global, this.seed, Noise2D.createCache(seed, minX, maxX, minZ, maxZ));
    }

    public double compute(DensityFunction.FunctionContext pos) {
        int cacheZ;
        if (this.cache == null || pos.blockX() < this.cache.minX || pos.blockX() > this.cache.maxX || pos.blockZ() < this.cache.minZ || pos.blockZ() > this.cache.maxZ) {
            return this.sampleWithoutCache(pos, this.seed);
        }
        int cacheX = pos.blockX() - this.cache.minX;
        double cachedValue = this.cache.cache[cacheX][cacheZ = pos.blockZ() - this.cache.minZ];
        if (Double.isNaN(cachedValue)) {
            this.cache.cache[cacheX][cacheZ] = cachedValue = (double)this.sampleWithoutCache(pos, this.seed + this.cache.featureSeed);
        }
        return cachedValue;
    }

    private float sampleWithoutCache(DensityFunction.FunctionContext pos, long seed) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.compute(pos));
        double x2 = (double)((long)pos.blockX() + (seed & 0xFFFFL)) * xzScale;
        double z = (double)((long)pos.blockZ() + (seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise2(seed, x2, z);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Noise2D((Either<Double, DensityFunction>)this.xzScale.mapRight(d -> d.mapAll(visitor)), this.global, this.seed, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return "__noise2d_" + (this.global ? "global" : "local") + "_" + this.seed;
    }

    private static Cache createCache(long featureSeed, int minX, int maxX, int minZ, int maxZ) {
        double[][] cache;
        for (double[] row : cache = new double[maxX - minX + 1][maxZ - minZ + 1]) {
            Arrays.fill(row, Double.NaN);
        }
        return new Cache(featureSeed, cache, minX, maxX, minZ, maxZ);
    }

    @Override
    public Noise2D setCache(Object cache) {
        return new Noise2D(this.xzScale, this.global, this.seed, (Cache)cache);
    }

    public Object getCache() {
        return this.cache;
    }

    private record Cache(long featureSeed, double[][] cache, int minX, int maxX, int minZ, int maxZ) {
    }
}

