/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureRandomNumber
implements DensityFunction,
FunctionWithCache {
    public static final MapCodec<FeatureRandomNumber> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min").forGetter(d -> d.min), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max").forGetter(d -> d.max), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("mean").forGetter(d -> d.mean), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("std").forGetter(d -> d.std), (App)Codec.BOOL.optionalFieldOf("integer", (Object)true).forGetter(d -> d.integer), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).fieldOf("seed").forGetter(d -> d.seed)).apply((Applicative)instance, FeatureRandomNumber::new));
    public static final KeyDispatchDataCodec<FeatureRandomNumber> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final DensityFunction min;
    public final DensityFunction max;
    public final Optional<DensityFunction> mean;
    public final Optional<DensityFunction> std;
    public final boolean integer;
    public final long seed;
    private final Cache cache;

    private FeatureRandomNumber(DensityFunction min, DensityFunction max, Optional<DensityFunction> mean, Optional<DensityFunction> std, boolean integer, long seed, Cache cache) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = cache;
    }

    public FeatureRandomNumber(DensityFunction min, DensityFunction max, Optional<DensityFunction> mean, Optional<DensityFunction> std, boolean integer, long seed) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = null;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.cache == null) {
            throw new RuntimeException("FeatureRandomNumber sampled outside of the feature type.");
        }
        return this.cache.value;
    }

    public double minValue() {
        return this.cache == null ? Double.NEGATIVE_INFINITY : this.cache.value;
    }

    public double maxValue() {
        return this.cache == null ? Double.POSITIVE_INFINITY : this.cache.value;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FeatureRandomNumber(this.min.mapAll(visitor), this.max.mapAll(visitor), this.mean.map(f -> f.mapAll(visitor)), this.std.map(f -> f.mapAll(visitor)), this.integer, this.seed, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    public FeatureRandomNumber create(long featureSeed) {
        double value;
        double maxValue;
        RandomSource random = RandomSource.create((long)(this.seed + featureSeed));
        double minValue = this.min.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
        if (minValue > (maxValue = this.max.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)))) {
            value = minValue;
        } else if (this.std.isPresent()) {
            double stdValue = this.std.get().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
            double meanValue = this.mean.map(m -> m.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0))).orElse((maxValue + minValue) / 2.0);
            value = random.nextGaussian() * stdValue + meanValue;
            value = Math.min(maxValue, Math.max(minValue, value));
            if (this.integer) {
                value = Math.round(value);
            }
        } else {
            value = this.integer ? (double)random.nextIntBetweenInclusive((int)minValue, (int)maxValue) : random.nextDouble() * (maxValue - minValue) + minValue;
        }
        return new FeatureRandomNumber(this.min, this.max, this.mean, this.std, this.integer, this.seed, new Cache(value));
    }

    @Override
    public String key() {
        return "__feature_random_number_" + this.seed;
    }

    @Override
    public FunctionWithCache setCache(Object cache) {
        return new FeatureRandomNumber(this.min, this.max, this.mean, this.std, this.integer, this.seed, (Cache)cache);
    }

    public Object getCache() {
        return this.cache;
    }

    private record Cache(double value) {
    }
}

