/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record MulAlongY(DensityFunction argument, DensityFunction minY, DensityFunction maxY) implements DensityFunction
{
    public static final MapCodec<MulAlongY> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(MulAlongY::argument), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_y").forGetter(MulAlongY::minY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_y").forGetter(MulAlongY::maxY)).apply((Applicative)instance, MulAlongY::new));
    public static final KeyDispatchDataCodec<MulAlongY> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        double sum = 1.0;
        for (int y = (int)this.minY.compute(pos); y <= (int)this.maxY.compute(pos); ++y) {
            sum *= this.argument.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.blockX(), y, pos.blockZ()));
        }
        return sum;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new MulAlongY(this.argument.mapAll(visitor), this.minY.mapAll(visitor), this.maxY.mapAll(visitor)));
    }

    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

