/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.duckling.common.entity.DuckEntity;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;

public class DuckEggEntity
extends ThrowableItemProjectile {
    public DuckEggEntity(EntityType<? extends DuckEggEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DuckEggEntity(Level level, LivingEntity owner) {
        super((EntityType)ModEntities.DUCK_EGG.get(), owner, level);
    }

    public DuckEggEntity(Level level, double d, double e, double f) {
        super((EntityType)ModEntities.DUCK_EGG.get(), d, e, f, level);
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        entityHitResult.getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(@NotNull HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide()) {
            if (this.random.nextInt(8) == 0) {
                int i = this.random.nextInt(32) == 0 ? 4 : 1;
                for (int j = 0; j < i; ++j) {
                    DuckEntity duck = (DuckEntity)((EntityType)ModEntities.DUCK.get()).create(this.level());
                    if (duck == null) continue;
                    duck.setAge(-24000);
                    BlockPos pos = this.blockPosition();
                    duck.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.getYRot(), 0.0f);
                    this.level().addFreshEntity((Entity)duck);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return ModItems.DUCK_EGG.get();
    }
}

