/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.duckling.common.constants.AnimationConstants;
import tech.thatgravyboat.duckling.common.constants.DuckVariant;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;
import tech.thatgravyboat.duckling.common.registry.ModSounds;

public class DuckEntity
extends TamableAnimal
implements GeoEntity {
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.BREAD});
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int eggLayTime = this.random.nextInt(6000) + 6000;

    public DuckEntity(EntityType<DuckEntity> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static boolean canDuckSpawn(EntityType<DuckEntity> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        if (type == MobSpawnType.SPAWNER) {
            return true;
        }
        return (level.isEmptyBlock(pos.above()) || level.isEmptyBlock(pos)) && level.getFluidState(pos.below()).is((Fluid)Fluids.WATER);
    }

    public static AttributeSupplier.Builder createDuckAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 4.0);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.is(ModItems.HOLIDAY_FRUIT_CAKE.get()) && this.isAlive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
            stackInHand.shrink(1);
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        if (stackInHand.isEmpty() && this.isAlive()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData group = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        this.getEntityData().set(VARIANT, (Object)(serverLevelAccessor.getRandom().nextBoolean() ? DuckVariant.MALLARD.id : DuckVariant.PEKIN.id));
        return group;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSounds.QUACK.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.DUCK_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return ModSounds.DUCK_DEATH.get();
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.getEntityData().set(VARIANT, (Object)DuckVariant.getVariant((String)nbt.getString((String)"Variant")).id);
        if (nbt.contains("EggLayTime")) {
            this.eggLayTime = nbt.getInt("EggLayTime");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getVariant().name());
        nbt.putInt("EggLayTime", this.eggLayTime);
        nbt.putBoolean("AgentD", this.getTexture().equals((Object)DuckVariant.AGENTD));
    }

    public void aiStep() {
        super.aiStep();
        Vec3 vec3d = this.getDeltaMovement();
        if (!this.onGround() && vec3d.y < 0.0) {
            this.setDeltaMovement(vec3d.multiply(1.0, 0.8, 1.0));
        }
        if (!this.level().isClientSide() && this.isAlive() && !this.isBaby() && --this.eggLayTime <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)ModItems.DUCK_EGG.get());
            this.eggLayTime = this.random.nextInt(6000) + 6000;
        }
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        return false;
    }

    @Nullable
    public DuckEntity getBreedOffspring(@NotNull ServerLevel world, @NotNull AgeableMob entity) {
        DuckEntity duckEntity = (DuckEntity)((EntityType)ModEntities.DUCK.get()).create((Level)world);
        DuckVariant variant = null;
        if (entity instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)entity;
            DuckVariant texture = this.getTexture();
            if (duck.getTexture() == texture && texture != DuckVariant.AGENTD) {
                variant = texture;
            }
        }
        if (duckEntity != null) {
            if (variant == null) {
                variant = world.random.nextBoolean() ? DuckVariant.PEKIN : DuckVariant.MALLARD;
            }
            duckEntity.getEntityData().set(VARIANT, (Object)variant.id);
        }
        return duckEntity;
    }

    public DuckVariant getVariant() {
        return DuckVariant.getVariant((Byte)this.entityData.get(VARIANT));
    }

    public DuckVariant getTexture() {
        return this.getName().getString().equalsIgnoreCase("agent d") ? DuckVariant.AGENTD : this.getVariant();
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER)) {
            event.getController().setAnimation(AnimationConstants.WALKING);
        } else if (!this.onGround()) {
            event.getController().setAnimation(AnimationConstants.FALLING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(AnimationConstants.WALKING);
        } else {
            event.getController().setAnimation(AnimationConstants.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

