/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.items;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.duckling.common.entity.DuckEggEntity;

public class DuckEggItem
extends Item
implements ProjectileItem {
    public DuckEggItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide()) {
            DuckEggEntity eggEntity = new DuckEggEntity(world, (LivingEntity)player);
            eggEntity.setItem(itemStack);
            eggEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)eggEntity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemStack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @NotNull
    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        DuckEggEntity eggEntity = new DuckEggEntity(level, position.x(), position.y(), position.z());
        eggEntity.setItem(itemStack);
        return eggEntity;
    }
}

