/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HolidayFruitCakeBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape)Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), (BooleanOp)BooleanOp.OR);

    public HolidayFruitCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            if (HolidayFruitCakeBlock.eat((LevelAccessor)level, pos, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return HolidayFruitCakeBlock.eat((LevelAccessor)level, pos, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(2, 0.1f);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        level.removeBlock(pos, false);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }
}

