/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CosmeticButton
extends Button {
    HatModel<Player> hat;
    PlayerModel<Player> playerModel;
    boolean darken;

    public CosmeticButton(int pX, int pY, int pWidth, int pHeight, CosmeticSelection model, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty(), pOnPress, Button.DEFAULT_NARRATION);
        Minecraft minecraft = Minecraft.getInstance();
        this.hat = new HatModel(model);
        this.playerModel = new PlayerModel(minecraft.getEntityModels().bakeLayer(ModelLayers.PLAYER), false);
        this.playerModel.young = false;
        this.playerModel.head.y = 24.0f;
        this.hat.attach((HumanoidModel<Player>)this.playerModel);
    }

    public boolean isCosmetic(CosmeticSelection model, String segment) {
        if (model.isCustom()) {
            if (this.hat.getHat().colors().getOrDefault(segment, Color.BLACK).equals(model.colors().getOrDefault(segment, Color.WHITE))) {
                return this.hat.getHat().equalsNoColor(model);
            }
            return false;
        }
        return this.hat.getHat().equalsNoColor(model);
    }

    public void update(boolean isEquipped, boolean isOwned) {
        this.active = !isEquipped;
        this.darken = !isOwned;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTicks) {
        float b;
        float g;
        float r;
        float f = this.darken ? 1.0f : (r = this.hat.getHat().isCustom() ? 0.7f : 0.9f);
        float f2 = this.darken ? 0.7f : (g = this.hat.getHat().isCustom() ? 1.0f : 1.0f);
        float f3 = this.darken ? 0.7f : (b = this.hat.getHat().isCustom() ? 0.7f : 0.9f);
        float c = this.darken ? 0.8f : (this.hat.getHat().isCustom() ? 1.0f : 1.0f);
        guiGraphics.setColor(r, g, b, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(c, c, c, this.alpha);
        float height = (float)this.getHeight() - 6.0f;
        float width = (float)this.getWidth() - 6.0f;
        float x = (float)this.getX() + 3.0f;
        float y = (float)this.getY() + 6.0f;
        float rotationX = ((float)mouseY / (float)guiGraphics.guiHeight() * 2.0f - 1.0f) * 11.0f;
        float rotationY = ((float)mouseX / (float)guiGraphics.guiWidth() * 2.0f - 1.0f) * -50.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x + width / 2.0f, y + height, 100.0f);
        float f4 = height / 2.125f;
        f4 = height / ((8.5f + (float)this.hat.centerHead()) / 16.0f);
        guiGraphics.pose().scale(f4, f4, f4);
        guiGraphics.pose().translate(0.0f, -0.0625f, 0.0f);
        guiGraphics.pose().rotateAround(Axis.XP.rotationDegrees(rotationX), 0.0f, -1.0625f, 0.0f);
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(rotationY));
        guiGraphics.flush();
        VersionHelper.setupForEntityInInventory(Axis.XP.rotationDegrees(rotationX));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f, 1.0f, -1.0f);
        guiGraphics.pose().translate(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)VersionHelper.toLoc("unionlib", "textures/cosmetics/head_preview.png")));
        VersionHelper.Client.renderToBuffer(this.playerModel, guiGraphics.pose(), vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        if (!Cosmetics.isEmpty(this.hat.getCosmetic())) {
            if (this.hat.getHat().isCustom()) {
                this.hat.getCosmetic().segments().forEach(segment -> {
                    VertexConsumer vertexConsumer2 = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)this.hat.getCosmetic().texture("custom_" + segment)));
                    VersionHelper.Client.renderToBuffer(this.hat, guiGraphics.pose(), vertexConsumer2, 0xF000F0, OverlayTexture.NO_OVERLAY, this.hat.getHat().colors().get(segment));
                });
            } else {
                VertexConsumer vertexConsumer2 = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)this.hat.getCosmetic().texture(this.hat.getHat().variant())));
                VersionHelper.Client.renderToBuffer(this.hat, guiGraphics.pose(), vertexConsumer2, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        }
        guiGraphics.pose().popPose();
        guiGraphics.flush();
        Lighting.setupFor3DItems();
        guiGraphics.pose().popPose();
    }
}

