/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.util.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class OverflowTextButton
extends Button {
    Component passedText;
    Component remainingText;
    int ticks;
    int completedTicks;

    public OverflowTextButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, pMessage, pOnPress, Button.DEFAULT_NARRATION);
        this.remainingText = pMessage;
        this.passedText = Component.literal((String)"");
    }

    public OverflowTextButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, Button.CreateNarration pCreateNarration) {
        super(pX, pY, pWidth, pHeight, pMessage, pOnPress, pCreateNarration);
        this.remainingText = pMessage;
        this.passedText = Component.literal((String)"");
    }

    public void setMessage(Component pMessage) {
        this.remainingText = pMessage;
        super.setMessage(pMessage);
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partial) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        boolean hasOverflow = false;
        boolean shouldhaveOverflow = false;
        Component buttonText = this.remainingText;
        int strWidth = minecraft.font.width((FormattedText)buttonText);
        int ellipsisWidth = minecraft.font.width("...");
        int actualStrWidth = minecraft.font.width((FormattedText)this.getMessage());
        int actualEllipsisWidth = minecraft.font.width("...");
        if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
            hasOverflow = true;
            buttonText = Component.literal((String)(minecraft.font.substrByWidth((FormattedText)buttonText, this.width - 6 - ellipsisWidth).getString() + "..."));
        } else {
            hasOverflow = false;
        }
        shouldhaveOverflow = actualStrWidth > this.width - 6 && actualStrWidth > actualEllipsisWidth;
        if (this.isHoveredOrFocused() && hasOverflow) {
            ++this.ticks;
            if (this.ticks >= UnionLib.CONFIG.textScrollSpeed) {
                this.ticks = 0;
                this.passedText = Component.literal((String)(this.passedText.getString() + this.remainingText.getString().charAt(0)));
                this.remainingText = Component.literal((String)this.remainingText.getString().substring(1));
            }
        } else if (this.isHoveredOrFocused() && shouldhaveOverflow && this.completedTicks < UnionLib.CONFIG.textScrollReset) {
            ++this.completedTicks;
        } else {
            this.ticks = 0;
            this.completedTicks = 0;
            this.remainingText = this.getMessage();
            this.passedText = Component.literal((String)"");
        }
        guiGraphics.drawCenteredString(minecraft.font, buttonText, ScreenHelper.getWidgetX((AbstractWidget)this) + this.width / 2, ScreenHelper.getWidgetY((AbstractWidget)this) + (this.height - 8) / 2, i);
    }

    private int getTextureY() {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (this.isHoveredOrFocused()) {
            i = 2;
        }
        return 46 + i * 20;
    }
}

