/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class HatModel<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(VersionHelper.toLoc("modid", "hat"), "main");
    private final CosmeticSelection hat;
    private final ModelPart headCopy;

    public HatModel(CosmeticSelection hat) {
        super(RenderType::entityTranslucent);
        this.hat = hat;
        ModelPart root = Cosmetics.allCosmetics().get(hat.cosmeticId()).bakeLayer();
        this.headCopy = root.getChild("Head");
    }

    public Cosmetic getCosmetic() {
        return Cosmetics.allCosmetics().get(this.hat.cosmeticId());
    }

    public CosmeticSelection getHat() {
        return this.hat;
    }

    public static LayerDefinition createBodyLayer(String id, String model) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition headCopy = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(32, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        UnderscoreParser.parse(id, model, headCopy);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer2(Cosmetic hat) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition headCopy = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(32, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = headCopy.addOrReplaceChild("hat1", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-4.5f, -3.0f, -4.5f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition hat2 = headCopy.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -7.0f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-4.5f, -15.0f, -4.5f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat3 = headCopy.addOrReplaceChild("hat3", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -9.0f, -3.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -9.0f, 2.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 2).addBox(2.0f, -9.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 2).addBox(-3.0f, -9.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition hat4 = headCopy.addOrReplaceChild("hat4", CubeListBuilder.create().texOffs(12, 7).addBox(4.0f, -5.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(6.0f, -10.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-8.0f, -5.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -10.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat5 = headCopy.addOrReplaceChild("hat5", CubeListBuilder.create().texOffs(28, 0).addBox(-4.5f, -10.0f, -4.5f, 9.0f, 2.0f, 9.0f, new CubeDeformation(0.1f)).texOffs(42, 12).addBox(4.0f, -8.0f, -5.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(46, 24).addBox(-4.0f, -8.0f, 4.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 12).addBox(-5.0f, -8.0f, -5.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(46, 24).addBox(-4.0f, -8.0f, -5.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -12.0f, -5.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-2.0f, -11.0f, -5.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 6).addBox(1.0f, -11.0f, -5.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 6).addBox(4.0f, -11.0f, -2.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(4.0f, -11.0f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(4.0f, -12.0f, 4.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(1.0f, -11.0f, 4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 6).addBox(-2.0f, -11.0f, 4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -12.0f, 4.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-5.0f, -11.0f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 6).addBox(-5.0f, -11.0f, -2.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(4.0f, -12.0f, -5.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(3.0f, -12.0f, 3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(2.0f, -12.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(1.0f, -12.0f, 1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-2.0f, -12.0f, 1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(-2.0f, -12.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-3.0f, -12.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(-4.0f, -12.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(3.0f, -12.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(2.0f, -12.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(1.0f, -12.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 11).addBox(-3.0f, -12.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-4.0f, -12.0f, 3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-4.0f, -12.0f, 3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-1.0f, -12.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-0.5f, -14.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void attach(HumanoidModel<T> player) {
        this.headCopy.copyFrom(player.head);
    }

    public int centerHead() {
        return Cosmetics.allCosmetics().get(this.hat.cosmeticId()).renderHeightOffset();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.headCopy.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    static class UnderscoreParser {
        private static final Pattern POSE = Pattern.compile("\\s*(-?\\d+\\.?\\d*),\\s*(-?\\d+\\.?\\d*),\\s*(-?\\d+\\.?\\d*)\\s*");
        private static final Pattern BOX = Pattern.compile("\\s*(\\d+),(\\d+),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(\\d+\\.?\\d*),(\\d+\\.?\\d*),(\\d+\\.?\\d*),(\\d+\\.?\\d*)\\s*");

        UnderscoreParser() {
        }

        public static PartDefinition parse(String id, String dsl, PartDefinition head) {
            String[] parts;
            if (id.isEmpty()) {
                id = "none";
            }
            if ((parts = dsl.split("><")).length < 2) {
                throw new IllegalArgumentException("Must have pose + at least one box");
            }
            Matcher mPose = POSE.matcher(parts[0]);
            if (!mPose.matches()) {
                throw new IllegalArgumentException("Invalid pose: " + parts[0]);
            }
            float offsetX = Float.parseFloat(mPose.group(1));
            float offsetY = Float.parseFloat(mPose.group(2));
            float offsetZ = Float.parseFloat(mPose.group(3));
            CubeListBuilder builder = CubeListBuilder.create();
            for (int i = 1; i < parts.length; ++i) {
                String boxStr = parts[i];
                Matcher mBox = BOX.matcher(boxStr);
                if (!mBox.matches()) {
                    throw new IllegalArgumentException("Invalid box: " + boxStr);
                }
                int u = Integer.parseInt(mBox.group(1));
                int v = Integer.parseInt(mBox.group(2));
                float x = Float.parseFloat(mBox.group(3));
                float y = Float.parseFloat(mBox.group(4));
                float z = Float.parseFloat(mBox.group(5));
                float w = Float.parseFloat(mBox.group(6));
                float h = Float.parseFloat(mBox.group(7));
                float d = Float.parseFloat(mBox.group(8));
                float def = Float.parseFloat(mBox.group(9));
                builder = builder.texOffs(u, v).addBox(x, y, z, w, h, d, new CubeDeformation(def));
            }
            return head.addOrReplaceChild(id, builder, PartPose.offset((float)offsetX, (float)offsetY, (float)offsetZ));
        }
    }

    static class DSLCubeListBuilder {
        private final CubeListBuilder delegate;
        private final List<String> records = new ArrayList<String>();

        private DSLCubeListBuilder() {
            this.delegate = CubeListBuilder.create();
        }

        public static DSLCubeListBuilder create() {
            return new DSLCubeListBuilder();
        }

        public DSLCubeListBuilder texOffs(int u, int v) {
            this.delegate.texOffs(u, v);
            this.records.add(u + "," + v);
            return this;
        }

        public DSLCubeListBuilder addBox(float x, float y, float z, float dx, float dy, float dz, CubeDeformation def) {
            int last = this.records.size() - 1;
            String prev = this.records.get(last);
            String boxPart = String.format(",%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(dx), Float.valueOf(dy), Float.valueOf(dz), Float.valueOf(0.0f));
            this.records.set(last, prev + boxPart);
            this.delegate.addBox(x, y, z, dx, dy, dz, def);
            return this;
        }

        public CubeListBuilder build() {
            return this.delegate;
        }

        public String toDslString(double ox, double oy, double oz) {
            String pose = String.format("%.1f,%.1f,%.1f", ox, oy, oz);
            String boxes = this.records.stream().collect(Collectors.joining("><"));
            return pose + "><" + boxes;
        }
    }
}

