/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.core.registries;

import com.stereowalker.unionlib.api.registries.BindableRegistryWrapper;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.api.registries.RegistryWrapper;
import com.stereowalker.unionlib.core.registries.ClassNRegistry;
import com.stereowalker.unionlib.core.registries.CustomNRegistry;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.neoforge.PlatformHelper;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterObjects {
    public static final Logger LOGGER = LogManager.getLogger((String)"UnionLib Registry");

    public static void putObjectsInGameRegistries(final MinecraftMod mod) {
        final ArrayList regs = new ArrayList();
        final ArrayList regs2 = new ArrayList();
        mod.setupRegistries(new RegistryCollector(){

            @Override
            public <T> void addRegistry(RegistryWrapper<T> wrapper, ResourceKey<Registry<T>> registryKey, boolean sync) {
                if (wrapper instanceof BindableRegistryWrapper) {
                    BindableRegistryWrapper bindable = (BindableRegistryWrapper)wrapper;
                    bindable.bind(PlatformHelper.createWrappedRegistry(mod, sync, registryKey));
                } else {
                    LOGGER.info("A registry wrapper for " + mod.getModid() + " is somehow not an instance of BindableRegistryWrapper");
                }
            }

            @Override
            public <T> void addCustom(ResourceKey<Registry<T>> registryKey, Consumer<RegistryCollector.Custom<T>> register) {
                regs2.add(new CustomNRegistry<T>(registryKey, register));
            }

            @Override
            public void addRegistryHolder(Class<?> holder) {
                if (!holder.isAnnotationPresent(RegistryHolder.class)) {
                    LOGGER.info(String.valueOf(holder) + " is missing the @RegistryHolder annotation. Include it to register the objects in this class");
                } else {
                    RegistryHolder reg = holder.getAnnotation(RegistryHolder.class);
                    if (reg.registry() == Block.class) {
                        regs.add(new ClassNRegistry(Registries.BLOCK, holder));
                    } else if (reg.registry() == DataComponentType.class) {
                        regs.add(new ClassNRegistry(Registries.DATA_COMPONENT_TYPE, holder));
                    } else if (reg.registry() == Fluid.class) {
                        regs.add(new ClassNRegistry(Registries.FLUID, holder));
                    } else if (reg.registry() == Item.class) {
                        regs.add(new ClassNRegistry(Registries.ITEM, holder));
                    } else if (reg.registry() == ArmorMaterial.class) {
                        regs.add(new ClassNRegistry(Registries.ARMOR_MATERIAL, holder));
                    } else if (reg.registry() == Attribute.class) {
                        regs.add(new ClassNRegistry(Registries.ATTRIBUTE, holder));
                    } else if (reg.registry() == MobEffect.class) {
                        regs.add(new ClassNRegistry(Registries.MOB_EFFECT, holder));
                    } else if (reg.registry() == Potion.class) {
                        regs.add(new ClassNRegistry(Registries.POTION, holder));
                    } else if (reg.registry() == RecipeSerializer.class) {
                        regs.add(new ClassNRegistry(Registries.RECIPE_SERIALIZER, holder));
                    } else if (reg.registry() == SensorType.class) {
                        regs.add(new ClassNRegistry(Registries.SENSOR_TYPE, holder));
                    } else if (reg.registry() == MenuType.class) {
                        regs.add(new ClassNRegistry(Registries.MENU, holder));
                    }
                }
            }

            @Override
            public <T> void addRegistryHolder(ResourceKey<Registry<T>> registryKey, Class<?> holder) {
                if (!holder.isAnnotationPresent(RegistryHolder.class)) {
                    LOGGER.info(String.valueOf(holder) + " is missing the @RegistryHolder annotation. Include it to register the objects in this class");
                } else {
                    regs.add(new ClassNRegistry<T>(registryKey, holder));
                }
            }
        });
        LOGGER.info("Found " + regs.size() + " registry classes in " + mod.getModid());
        for (ClassNRegistry classs : regs) {
            RegistryHolder reg = classs.classs.getAnnotation(RegistryHolder.class);
            LOGGER.info("Registering " + String.valueOf(classs.registryKey.location()) + "s in " + String.valueOf(classs));
            String namespace = reg.namespace().isEmpty() ? mod.getModid() : reg.namespace();
            PlatformHelper.handleRegistration(mod, namespace, classs.classs.getFields(), classs.registryKey, LOGGER);
        }
        regs2.forEach(custom -> custom.invoke(mod));
        PlatformHelper.doCreativeTabs(mod);
    }
}

