/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.hook;

import com.stereowalker.unionlib.hook.AccessoryStackCalls;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.AccessorySlotGroup;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import com.stereowalker.unionlib.world.item.component.AccessoryAttributeModifiers;
import com.stereowalker.unionlib.world.item.component.UDataComponents;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface AccessoryStack {
    default public ItemStack self() {
        return (ItemStack)this;
    }

    default public AccessoryItem getAccessory() {
        return (AccessoryItem)this.self().getItem();
    }

    default public void forEachModifier(AccessorySlot pEquipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction) {
        AccessoryStackCalls.forEachModifier(this.self(), pEquipmentSLot, pAction);
    }

    default public void forEachModifier(AccessorySlotGroup pEquipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction) {
        AccessoryAttributeModifiers itemattributemodifiers = (AccessoryAttributeModifiers)this.self().getOrDefault(UDataComponents.ATTRIBUTE_MODIFIERS, (Object)AccessoryAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(pEquipmentSLot, pAction);
        } else {
            AccessoryAttributeModifiers.EMPTY.forEach(pEquipmentSLot, pAction);
        }
    }

    default public void addTooltipLines(Player pPlayer, Consumer<Component> list) {
        if (this.self().getItem() instanceof AccessoryItem) {
            for (AccessorySlotGroup accessoryslot : AccessorySlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.forEachModifier(accessoryslot, (Holder<Attribute> attribute, AttributeModifier modifier) -> {
                    if (mutableboolean.isTrue()) {
                        list.accept(CommonComponents.EMPTY);
                        list.accept((Component)Component.translatable((String)("item.modifiers." + accessoryslot.getSerializedName())).withStyle(ChatFormatting.GRAY));
                        mutableboolean.setFalse();
                    }
                    AccessoryStackCalls.gatherAttributes(this.self(), list, pPlayer, (Holder<Attribute>)attribute, modifier);
                });
            }
        }
    }
}

