/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.insert;

import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class InsertResultCancellerImpl<T>
implements InsertResultCanceller<T> {
    T value;
    MutableBoolean wasCanceled;
    Runnable doOnCancel;

    public InsertResultCancellerImpl(T startingValue, Runnable doOnCancel) {
        this.value = startingValue;
        this.wasCanceled = new MutableBoolean();
        this.doOnCancel = doOnCancel;
    }

    @Override
    public void cancel(T value) {
        this.value = value;
        this.wasCanceled.setTrue();
    }

    @Override
    public T cancelResult() {
        return this.value;
    }

    @Override
    public boolean wasCancelled() {
        return this.wasCanceled.booleanValue();
    }

    public void applyOnCancel(Consumer<T> con) {
        if (this.wasCancelled()) {
            con.accept(this.cancelResult());
            this.doOnCancel.run();
        }
    }

    public void invalidateCancel(Function<T, Boolean> con) {
        if (this.wasCancelled() && con.apply(this.cancelResult()).booleanValue()) {
            this.wasCanceled.setFalse();
        }
    }
}

