/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.stereowalker.unionlib.hook.NeedleHooks;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin
extends ProjectileWeaponItem {
    public BowItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;getPowerForTime(I)F"))
    public float releaseUsing_redirect1(int charge, ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            return NeedleHooks.getBowPowerForTime(charge, player);
        }
        return BowItem.getPowerForTime((int)charge);
    }

    @Redirect(method={"shootProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"))
    public void shootProjectile_redirect(Projectile pProjectile, Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        if (ModHandler.getLoadState().runsOnBothSides() && pShooter instanceof Player) {
            Player player = (Player)pShooter;
            float accuracy = 1.0f;
            float velocity = 1.0f;
            float damage = 0.0f;
            if (player.getAttribute(UAttributes.ACCURACY.holder()) != null) {
                accuracy = (float)player.getAttributeValue(UAttributes.ACCURACY.holder());
            }
            if (player.getAttribute(UAttributes.ARROW_VELOCITY.holder()) != null) {
                velocity = (float)player.getAttributeValue(UAttributes.ARROW_VELOCITY.holder());
            }
            if (player.getAttribute(UAttributes.ARROW_DAMAGE.holder()) != null) {
                damage = (float)player.getAttributeValue(UAttributes.ARROW_DAMAGE.holder());
            }
            pProjectile.shootFromRotation(pShooter, pX, pY, pZ, pVelocity * velocity, 2.0f - accuracy * 2.0f);
            if (pProjectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)pProjectile;
                arrow.setBaseDamage(arrow.getBaseDamage() + (double)damage);
            }
        } else {
            pProjectile.shootFromRotation(pShooter, pX, pY, pZ, pVelocity, pInaccuracy);
        }
    }
}

