/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.neoforge;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.BrewingRecipeCollector;
import com.stereowalker.unionlib.api.collectors.ColorOverrideCollector;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.FluidPropertyCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.collectors.OverlayCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ParticleCollector;
import com.stereowalker.unionlib.api.collectors.RenderLayerCollector;
import com.stereowalker.unionlib.client.gui.GuiRendererImpl;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.core.registries.Housing;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public abstract class NeoforgeMod {
    public Optional<? extends ModContainer> container;
    public static final Map<Fluid, DeferredHolder<FluidType, FluidType>> fluidTypes = new HashMap<Fluid, DeferredHolder<FluidType, FluidType>>();
    static final List<Runnable> after = new ArrayList<Runnable>();

    public abstract String getModid();

    public void attemptToSusOutContainer() {
        ArrayList s = Lists.newArrayList((Object[])new String[]{"concept_keys", "concept_object", "concept_combined_config", "concept_class"});
        String modId = s.contains(this.getModid()) ? "unionlib" : this.getModid();
        this.container = ModList.get().getModContainerById(modId);
        if (this.container.isEmpty()) {
            for (ModContainer container2 : ModList.get().getSortedMods()) {
                if (container2.getModId() != modId) continue;
                this.container = Optional.of(container2);
                break;
            }
        }
    }

    public IEventBus eventBus() {
        if (this.container == null || this.container.isEmpty()) {
            this.attemptToSusOutContainer();
            if (this.container.isEmpty()) {
                return ModLoadingContext.get().getActiveContainer().getEventBus();
            }
        }
        return this.container.get().getEventBus();
    }

    public ModContainer modContainer() {
        if (this.container == null || this.container.isEmpty()) {
            this.attemptToSusOutContainer();
            if (this.container.isEmpty()) {
                return ModLoadingContext.get().getActiveContainer();
            }
        }
        return this.container.get();
    }

    public void commonStuff() {
        final MinecraftMod mod = (MinecraftMod)this;
        final DeferredRegister FLUIDTYPE = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)mod.getModid());
        mod.setupFluids(new FluidPropertyCollector(){

            @Override
            public void forFluid(final FluidProperties property, Supplier<Fluid> ... fluid) {
                FluidType TYPE = new FluidType(this, FluidType.Properties.create().descriptionId("block.survive.purified_water").canConvertToSource(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canHydrate(true).density(10).viscosity(10)){

                    public boolean supportsBoating(Boat boat) {
                        return property.supportsBoats(boat);
                    }

                    public boolean supportsBoating(FluidState state, Boat boat) {
                        return property.supportsBoats(state, boat);
                    }

                    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
                        return property.move(state, entity, movementVector, gravity);
                    }

                    public boolean canPushEntity(Entity entity) {
                        return property.canPushEntity(entity);
                    }

                    public boolean canSwim(Entity entity) {
                        return property.canSwim(entity);
                    }

                    public boolean canExtinguish(Entity entity) {
                        return property.canExtinguish(entity);
                    }

                    public boolean canDrownIn(LivingEntity entity) {
                        return property.canDrownIn(entity);
                    }

                    public double motionScale(Entity entity) {
                        return property.motionScale(entity);
                    }

                    public float getFallDistanceModifier(Entity entity) {
                        return property.fallDistanceModifier(entity);
                    }

                    public void setItemMovement(ItemEntity entity) {
                        property.itemMovement(entity);
                    }

                    @Nullable
                    public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                        return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
                    }

                    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                        consumer.accept(new IClientFluidTypeExtensions(){
                            private static final ResourceLocation UNDERWATER_LOCATION = VersionHelper.toLoc("textures/misc/underwater.png");

                            public ResourceLocation getStillTexture() {
                                return property.stillTexture();
                            }

                            public ResourceLocation getFlowingTexture() {
                                return property.flowingTexture();
                            }

                            @Nullable
                            public ResourceLocation getOverlayTexture() {
                                return property.overlayTexture();
                            }

                            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                                return UNDERWATER_LOCATION;
                            }

                            public int getTintColor() {
                                return property.tintColor();
                            }

                            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                                return property.tintColor(state, getter, pos);
                            }
                        });
                    }
                };
                DeferredHolder type = FLUIDTYPE.register(property.name().getPath(), () -> TYPE);
                after.add(() -> {
                    for (Supplier f : fluid) {
                        FluidProperties.fluidProps.put((Fluid)f.get(), property);
                        fluidTypes.put((Fluid)f.get(), (DeferredHolder<FluidType, FluidType>)type);
                    }
                });
            }
        });
        FLUIDTYPE.register(this.eventBus());
        mod.setupConfigs(new ConfigCollector(){

            @Override
            public void registerConfig(ConfigObject configObject) {
                ConfigBuilder.registerConfig(mod, configObject);
            }

            @Override
            public void registerConfig(Class<?> configClass) {
                ConfigBuilder.registerConfig(mod, configClass);
            }
        });
        if (this instanceof PacketHolder) {
            this.eventBus().addListener(event -> {
                final PayloadRegistrar registrar = event.registrar(this.NETWORK_PROTOCOL_VERSION());
                UnionLib.debug("Registering packets on server for mod: " + mod.getModid());
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
                    ((PacketHolder)((Object)mod)).registerPackets(new PacketCollector(){

                        @Override
                        public <T extends ServerboundUnionPacket> void registerServerboundPacket(ResourceLocation id, Class<T> messageType, Function<RegistryFriendlyByteBuf, T> decoder) {
                            registrar.playToServer(new CustomPacketPayload.Type(id), StreamCodec.ofMember(BasePacket::encode, decoder::apply), ServerboundUnionPacket::message);
                        }

                        @Override
                        public <T extends ClientboundUnionPacket> void registerClientboundPacket(ResourceLocation id, Class<T> messageType, Function<RegistryFriendlyByteBuf, T> decoder) {
                            registrar.playToClient(new CustomPacketPayload.Type(id), StreamCodec.ofMember(BasePacket::encode, decoder::apply), ClientboundUnionPacket::message);
                        }
                    });
                    UnionLib.debug(mod.getModid() + "'s Serverbound & Clientbound packets registered");
                } else {
                    UnionLib.debug("Not registering " + mod.getModid() + "'s Serverbound packets Because [This: -> " + String.valueOf((Object)mod.getLoadType()) + " <- Game: -> " + String.valueOf((Object)ModHandler.getLoadState()) + " <-]");
                }
            });
        }
        this.eventBus().addListener(clientEvent -> mod.onModStartup());
        this.eventBus().addListener(clientEvent -> after.forEach(Runnable::run));
        this.eventBus().addListener(event -> {
            if (UnionLib.Modulo.Default_Bow_Draw_Speed.isActive()) {
                event.modifyMatching(item -> item instanceof BowItem, builder -> builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)UnionLib.createBowAttributes(ItemAttributeModifiers.builder().build())));
            }
        });
        this.eventBus().addListener(event -> {
            if (((MinecraftMod)this).getClientSegment() != null) {
                ((MinecraftMod)this).getClientSegment().setupMenus(new MenuCollector(){
                    final /* synthetic */ RegisterMenuScreensEvent val$event;
                    {
                        this.val$event = registerMenuScreensEvent;
                    }

                    @Override
                    public <M extends AbstractContainerMenu, U extends Screen> void addMenu(MenuType<? extends M> pType, MenuScreens.ScreenConstructor<M, U> pFactory) {
                        this.val$event.register(pType, pFactory);
                    }
                });
            }
        });
        if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
            NeoForge.EVENT_BUS.addListener(event -> mod.setupBrewingRecipes(new BrewingRecipeCollector(){
                final /* synthetic */ RegisterBrewingRecipesEvent val$event;
                {
                    this.val$event = registerBrewingRecipesEvent;
                }

                @Override
                public PotionBrewing.Builder builder() {
                    return this.val$event.getBuilder();
                }

                @Override
                public void addMix(Housing<Potion> input, Item reagent, Housing<Potion> result) {
                    this.val$event.getBuilder().addMix(input.holder(), reagent, result.holder());
                }

                @Override
                public void addMix(Holder<Potion> input, Item reagent, Housing<Potion> result) {
                    this.val$event.getBuilder().addMix(input, reagent, result.holder());
                }

                @Override
                public void addMix(Housing<Potion> input, Item reagent, Holder<Potion> result) {
                    this.val$event.getBuilder().addMix(input.holder(), reagent, result);
                }

                @Override
                public void addMix(Holder<Potion> input, Item reagent, Holder<Potion> result) {
                    this.val$event.getBuilder().addMix(input, reagent, result);
                }
            }));
        }
        NeoForge.EVENT_BUS.addListener(event -> ((MinecraftMod)this).setupCommands(new CommandCollector(){
            final /* synthetic */ RegisterCommandsEvent val$event;
            {
                this.val$event = registerCommandsEvent;
            }

            @Override
            public Commands.CommandSelection selection() {
                return this.val$event.getCommandSelection();
            }

            @Override
            public CommandDispatcher<CommandSourceStack> dispatcher() {
                return this.val$event.getDispatcher();
            }

            @Override
            public CommandBuildContext context() {
                return this.val$event.getBuildContext();
            }
        }));
    }

    public void clientStuff() {
        MinecraftMod mod = (MinecraftMod)this;
        this.eventBus().addListener(clientEvent -> {
            mod.onModStartupInClient();
            mod.getClientSegment().setupRenderLayers(new RenderLayerCollector(this){

                @Override
                public void setItemRenderLayer(RenderType renderLayer, Item ... items) {
                    for (Item item : items) {
                        ItemBlockRenderTypes.setRenderLayer((Block)Block.byItem((Item)item), (RenderType)renderLayer);
                    }
                }

                @Override
                public void setFluidRenderLayer(RenderType renderLayer, Fluid ... fluids) {
                    for (Fluid fluid : fluids) {
                        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)renderLayer);
                    }
                }

                @Override
                public void setBlockRenderLayer(RenderType renderLayer, Block ... blocks) {
                    for (Block block : blocks) {
                        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderLayer);
                    }
                }
            });
        });
        this.eventBus().addListener(mapEvent -> mod.getClientSegment().setupKeymappings(arg_0 -> ((RegisterKeyMappingsEvent)mapEvent).register(arg_0)));
        this.eventBus().addListener(guiEvent -> {
            Gui gui = Minecraft.getInstance().gui;
            mod.getClientSegment().setupGuiOverlays(new OverlayCollector(){
                final /* synthetic */ RegisterGuiLayersEvent val$guiEvent;
                final /* synthetic */ Gui val$gui;
                {
                    this.val$guiEvent = registerGuiLayersEvent;
                    this.val$gui = gui;
                }

                @Override
                public void register(String id, OverlayCollector.Order order, OverlayCollector.Overlay overlay) {
                    if (order == OverlayCollector.Order.START) {
                        this.val$guiEvent.registerAboveAll(VersionHelper.toLoc(id), (guiGraphics, b) -> overlay.render(this.val$gui, new GuiRendererImpl(guiGraphics, b.getGameTimeDeltaPartialTick(false)), guiGraphics.guiWidth(), guiGraphics.guiHeight()));
                    }
                    if (order == OverlayCollector.Order.END) {
                        this.val$guiEvent.registerBelowAll(VersionHelper.toLoc(id), (guiGraphics, b) -> overlay.render(this.val$gui, new GuiRendererImpl(guiGraphics, b.getGameTimeDeltaPartialTick(false)), guiGraphics.guiWidth(), guiGraphics.guiHeight()));
                    }
                }
            });
        });
        this.eventBus().addListener(blockColorEvent -> mod.getClientSegment().setupColorOverrides(new ColorOverrideCollector(){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$blockColorEvent;
            {
                this.val$blockColorEvent = block;
            }

            @Override
            public void overrideBlocks(BlockColor color, Block ... blocks) {
                this.val$blockColorEvent.register(color, blocks);
            }

            @Override
            public void overrideItems(ItemColor color, Item ... items) {
            }
        }));
        this.eventBus().addListener(itemColorEvent -> mod.getClientSegment().setupColorOverrides(new ColorOverrideCollector(){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$itemColorEvent;
            {
                this.val$itemColorEvent = item;
            }

            @Override
            public void overrideItems(ItemColor color, Item ... items) {
                this.val$itemColorEvent.register(color, (ItemLike[])items);
            }

            @Override
            public void overrideBlocks(BlockColor color, Block ... blocks) {
            }
        }));
        this.eventBus().addListener(particleEvent -> mod.getClientSegment().setupParticles(new ParticleCollector(){
            final /* synthetic */ RegisterParticleProvidersEvent val$particleEvent;
            {
                this.val$particleEvent = registerParticleProvidersEvent;
            }

            @Override
            public void addTexture(ResourceLocation particle) {
            }

            @Override
            public <T extends ParticleOptions> void addFactory(ParticleType<T> type, ParticleEngine.SpriteParticleRegistration<T> registration) {
                this.val$particleEvent.registerSpriteSet(type, registration);
            }
        }));
    }

    public String NETWORK_PROTOCOL_VERSION() {
        return "1";
    }

    public String getVersion() {
        if (this.getModInfo() != null) {
            return MavenVersionTranslator.artifactVersionToString((ArtifactVersion)this.getModInfo().getVersion());
        }
        return "???";
    }

    public IModInfo getModInfo() {
        Mutable<IModInfo> modInfo = new Mutable<IModInfo>(this){
            IModInfo modInfo;

            public void setValue(IModInfo value) {
                this.modInfo = value;
            }

            public IModInfo getValue() {
                return this.modInfo;
            }
        };
        ModList.get().getMods().forEach(arg_0 -> this.lambda$getModInfo$15((Mutable)modInfo, arg_0));
        return (IModInfo)modInfo.getValue();
    }

    public void setupConfigScreen(ClientSegment client) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (container, list) -> client.getConfigScreen(Minecraft.getInstance(), list));
    }

    private /* synthetic */ void lambda$getModInfo$15(Mutable modInfo, IModInfo mod) {
        if (mod.getModId() == this.getModid()) {
            modInfo.setValue((Object)mod);
        }
    }
}

