/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.protocol.game;

import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class ClientboundUnionPacket
extends BasePacket {
    public ClientboundUnionPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
    }

    @Override
    public void message(IPayloadContext context) {
        if (this.shouldRun()) {
            context.enqueueWork(() -> ClientExecute.run(this));
        }
    }

    public boolean verifyIfHandled() {
        return false;
    }

    public boolean shouldRun() {
        return true;
    }

    @Deprecated
    public boolean handleOnClient(LocalPlayer player) {
        return false;
    }

    public boolean runOnClient(Player player) {
        return false;
    }

    public void send(ServerPlayer playerEntity) {
        PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void send(ServerLevel world) {
        for (ServerPlayer playerEntity : world.players()) {
            this.send(playerEntity);
        }
    }

    public void send(MinecraftServer server) {
        for (ServerPlayer playerEntity : server.getPlayerList().getPlayers()) {
            this.send(playerEntity);
        }
    }

    public static class ClientExecute {
        public static boolean run(ClientboundUnionPacket pack) {
            pack.handleOnClient(Minecraft.getInstance().player);
            return pack.runOnClient((Player)Minecraft.getInstance().player);
        }
    }
}

